package com.intel.gpe.gridbeans.gridbeanservice;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;

import com.intel.gpe.gridbeans.GetGridBeanDocument;
import com.intel.gpe.gridbeans.GetGridBeanInfoDocument;
import com.intel.gpe.gridbeans.GetGridBeanInfoResponseDocument;
import com.intel.gpe.gridbeans.GetGridBeanResponseDocument;
import com.intel.gpe.gridbeans.GridBeanService;
import com.intel.gpe.gridbeans.GridBeanServiceImpl;
import com.intel.gpe.gridbeans.ListGridBeansDocument;
import com.intel.gpe.gridbeans.ListGridBeansResponseDocument;

import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.wsrflite.xfire.JettyTestCase;
import de.fzj.unicore.wsrflite.xfire.WSRFClientFactory;
import de.fzj.unicore.wsrflite.xfire.XFireServiceFactory;

/**
 * gridbean service tests
 */
public class TestService extends JettyTestCase {

	private GridBeanService gbs;
	
	protected void setUp()throws Exception{
		super.setUp();
		WSRFClientFactory factory=new WSRFClientFactory();
		gbs=(GridBeanService)factory.createPlainWSProxy(GridBeanService.class,
				getBaseurl()+"/"+GridBeanService.ServiceName);
	}
	
	@Override
	protected void addServices() throws Exception {
		UASProperties props = new UASProperties(new Properties());
		props.setProperty(UASProperties.GRIDBEAN_DIR, "src/test/resources/test-gridbeans");
		kernel.setAttribute(UASProperties.class, props);
		XFireServiceFactory.createAndDeployService(kernel, GridBeanService.ServiceName,
				GridBeanService.class, GridBeanServiceImpl.class, false);
	}

	public void testAll(){
		doTestListGridBeans();
		doTestGetInfo();
		doTestDownload();
	}
	
	public void doTestListGridBeans(){
		try{
			ListGridBeansDocument lgbd=ListGridBeansDocument.Factory.newInstance();
			lgbd.addNewListGridBeans();
			ListGridBeansResponseDocument res=gbs.ListGridBeans(lgbd);
			assertNotNull(res);
			System.out.println(res);
			assertTrue(res.getListGridBeansResponse().
					getAvailableGridBeansArray(0).getName().equals("Destroy"));
		}catch(Exception e){
			e.printStackTrace();
			fail();
		}
	}
	
	public void doTestGetInfo(){
		try{
			GetGridBeanInfoDocument in=GetGridBeanInfoDocument.Factory.newInstance();
			in.addNewGetGridBeanInfo().setName("Destroy");
			
			GetGridBeanInfoResponseDocument res=gbs.GetGridBeanInfo(in);
			assertNotNull(res);
			System.out.println(res);
			assertTrue(res.getGetGridBeanInfoResponse().getGridBeanInfo().getName().equals("Destroy"));
		}catch(Exception e){
			e.printStackTrace();
			fail();
		}
	}
	
	public void doTestDownload(){
		try{
			GetGridBeanDocument in=GetGridBeanDocument.Factory.newInstance();
			in.addNewGetGridBean().setName("Destroy");
			GetGridBeanResponseDocument res=gbs.GetGridBean(in);
			assertNotNull(res);
			//System.out.println(res);
			byte[] bytes=res.getGetGridBeanResponse().getContents();
			byte[] orig=readBytesFromFile(
					new File("src/test/resources/test-gridbeans/DestroyGridBean.jar"));
			assertTrue(Arrays.equals(bytes,orig));
			
		}catch(Exception e){
			e.printStackTrace();
			fail();
		}
	}
	
	private static byte[] readBytesFromFile(File file) throws IOException {
		InputStream is = new FileInputStream(file);
		long length = file.length();
		if (length > Integer.MAX_VALUE) {
			throw new IOException("File size " + length + " is too large.");
		}
		byte[] bytes = new byte[(int) length];
		int offset = 0;
		int numRead = 0;
		while (offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
			offset += numRead;
		}
		if (offset < bytes.length) {
			throw new IOException("Could not completely read file " + file.getName());
		}
		is.close();
		return bytes;
	}
}
