package com.intel.gpe.gridbeans;

import java.io.File;
import java.io.IOException;

import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xfire.XFireKernel;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryHandler;

//TODO - this should be changed to use new style startup tasks + configuration should be created with 2 variables
//directory and enable/disable (if setting in wsrflite.xml is not enough?)
public class PublishGridBeanService implements Runnable {

	private static final Logger logger=LogUtil.getLogger(LogUtil.SERVICES,PublishGridBeanService.class);

	private final Kernel kernel;
	
	public PublishGridBeanService(Kernel kernel){
		this.kernel=kernel;
	}
	
	public void run() {
		publish();
	}

	protected void publish(){
		try {
			if(XFireKernel.get(kernel).getService(GridBeanService.ServiceName)==null){
				logger.error("GridBean service is not deployed, please check your configuration.");
				return;
			}
			checkCreateDirectory();
			RegistryHandler rh = kernel.getAttribute(RegistryHandler.class);
			rh.getRegistryClient().addRegistryEntry(getEPR());
			logger.info("Added registry entry for "+GridBeanService.ServiceName);
		}catch(Exception e){
			LogUtil.logException("Could not publish to registry",e,logger);
		}
	}

	protected synchronized EndpointReferenceType getEPR(){
		EndpointReferenceType myEPR=WSServerUtilities.newEPR(kernel.getContainerSecurityConfiguration());
		myEPR.addNewAddress().setStringValue(WSServerUtilities.makeAddress(GridBeanService.ServiceName, 
				kernel.getContainerProperties()));
		WSServerUtilities.addPortType(myEPR,GridBeanService.PORT_TYPE);
		return myEPR;
	}
	
	
	protected void checkCreateDirectory()throws IOException{
		String dir=getGridBeanPath();
		if(dir==null){
			throw new IOException("Gridbean directory not defined! "
					 +"please define it using the <"+
					UASProperties.PREFIX+UASProperties.GRIDBEAN_DIR
					 +"> property.");
		}
		
		File file=new File(dir);
		if(!file.exists()){
			boolean created=file.mkdirs();
			if(!created){
				throw new IOException("Could not create Gridbean directory: <"+dir+">");
			}
		}
		else{
			if(!file.isDirectory()){
				throw new IOException("Not a valid Gridbean directory: <"+dir+">");
			}
		}
	}
	
	protected String getGridBeanPath(){
		UASProperties uasProperties = kernel.getAttribute(UASProperties.class);
		String res=uasProperties.getValue(UASProperties.GRIDBEAN_DIR);
		return res;
	}
}
