package eu.unicore.genii.security;

import java.io.File;
import java.util.List;
import java.util.Map;

import javax.security.auth.x500.X500Principal;

import junit.framework.TestCase;
import de.fzj.unicore.uas.util.Pair;
import edu.virginia.vcgr.genii.security.X500PrincipalUtilities;
import eu.unicore.uas.security.gridmapfile.GridMapFileParser;


public class TestGridMapFileParsing extends TestCase {


	public void estSingleLine() throws Exception{
		Pair<String,String[]> mapping = GridMapFileParser.parseLine("\"/C=DE/O=GridGermany/OU=Forschungszentrum Juelich GmbH/CN=Morris Riedel\" communig");

		X500Principal x500 = new X500Principal("C=DE,O=GridGermany,OU=Forschungszentrum Juelich GmbH,CN=Morris Riedel");
		String normalizedDN = X500PrincipalUtilities.getCanonicalizedString(x500);
		assertEquals(normalizedDN, mapping.getM1());
		assertEquals("communig", mapping.getM2()[0]);

	}


	public void testWholeFile() throws Exception{
		GridMapFileParser parser = new GridMapFileParser(new File("src/test/resources/grid-mapfile"));
		Map<String,List<String>> map = parser.parse();
		X500Principal x500 = new X500Principal("C=DE,O=GridGermany,OU=Forschungszentrum Juelich GmbH,CN=Morris Riedel");
		String normalizedDN = X500PrincipalUtilities.getCanonicalizedString(x500);
		List<String> logins = map.get(normalizedDN);
		assertNotNull(logins);
		assertEquals(1, logins.size());
		assertEquals("communig", logins.get(0));

		x500 = new X500Principal("C=UK,C=UK,O=eScience,OU=UCL,L=EISD,CN=david wright");
		normalizedDN = X500PrincipalUtilities.getCanonicalizedString(x500);

		logins = map.get(normalizedDN);
		assertNotNull(logins);
		assertEquals(2, logins.size());
		assertEquals("daveww", logins.get(0));
		assertEquals("dave", logins.get(1));

	}	
	
	public void testOtherFile() throws Exception{
		File f = new File("src/test/resources/grid-mapfile2");
		GridMapFileParser parser = new GridMapFileParser(f);
		Map<String,List<String>> map = parser.parse();
		assertEquals(0, parser.getNumError());
		
	}	

}





