package eu.unicore.genii.security;

import static org.junit.Assert.assertTrue;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.Properties;

import javax.xml.namespace.QName;

import mockit.Mock;
import mockit.MockUp;
import mockit.Mockit;

import org.codehaus.xfire.service.Service;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.oasisOpen.docs.wsrf.rl2.CurrentTimeDocument;
import org.oasisOpen.docs.wsrf.rp2.GetResourcePropertyDocument;

import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.ISecurityProperties;
import de.fzj.unicore.wsrflite.security.UASSecurityProperties;
import de.fzj.unicore.wsrflite.xfire.WSRFClientFactory;
import de.fzj.unicore.wsrflite.xfire.XFireKernel;
import de.fzj.unicore.wsrflite.xfire.XFireServiceFactory;
import edu.virginia.vcgr.genii.security.credentials.assertions.AttributeInvalidException;
import edu.virginia.vcgr.genii.security.credentials.assertions.DelegatedAssertion;
import eu.unicore.genii.GenesisConstants;


public class TestGAMLAssertionHandler {

	private static final String TESTSERVICENAME = "GAMLAssertionTokenService";

	@BeforeClass
	public static void startServer()throws Exception{
		UAS uas=new UAS("src/test/resources/uas.config.simple");
		uas.startSynchronous();
		Kernel.getKernel().setProperty(GenesisConstants.PROP_TRUSTED_ID_PROVIDER_DIR, "src/test/resources/trustedCerts");
		XFireServiceFactory.createAndDeployService(TESTSERVICENAME,IExample.class, ExampleService.class, false);
		Service s=XFireKernel.getService(TESTSERVICENAME);
		s.addInHandler(new GAMLAssertionInHandler());
	}

	private static String secPropsOut=
		ISecurityProperties.WSRF_SSL + "=true"+"\n"+
		ISecurityProperties.WSRF_SSL_CLIENTAUTH + "=true" +"\n"+
		ISecurityProperties.WSRF_SSL_KEYSTORE + "=src/main/certs/user-keystore.jks" +"\n"+
		ISecurityProperties.WSRF_SSL_KEYPASS + "=the!user"+"\n"+
		ISecurityProperties.WSRF_SSL_KEYTYPE + "=jks"+"\n"+
		ISecurityProperties.WSRF_SSL_TRUSTSTORE + "=src/main/certs/user-keystore.jks" +"\n"+
		ISecurityProperties.WSRF_SSL_TRUSTPASS + "=the!user\n";



	@Test
	public void testGamlOutHandler() throws Exception{

		GamlAssertionOutHandler gaml = new GamlAssertionOutHandler();
		assertTrue(gaml.getSoapHeaderAsString().contains("calling-context"));

	}



	@Test
	public void testGamlInHandler() throws Exception{
		new MockUp<DelegatedAssertion>() {
		
			@Mock
			@SuppressWarnings("unused")
			public void checkValidity(int delegationDepth, Date date)
			throws AttributeInvalidException
			{
				// skip check
				
			}	

		};

		new MockUp<TrustDelegationUtils>() {
			@Mock
			@SuppressWarnings("unused")
			public void checkTransportCertEqualsAuthorizedCert(Certificate transport, Certificate authorized) {
				// do nothing at all
			}
		};
		
		ISecurityProperties sec=new UASSecurityProperties(new Properties(),new ByteArrayInputStream(secPropsOut.getBytes()));
		sec.setProperty(ISecurityProperties.UAS_OUTHANDLER_NAME, GamlAssertionOutHandler.class.getName());
		sec.setSignMessage(false);

		IExample example = new WSRFClientFactory(sec).createPlainWSProxy(IExample.class, Kernel.getKernel().getProperty(Kernel.WSRF_BASEURL)+"/"+TESTSERVICENAME);
		GetResourcePropertyDocument in=GetResourcePropertyDocument.Factory.newInstance();
		in.setGetResourceProperty(new QName("Hello","World"));
		CurrentTimeDocument doc = example.getTime(in);
		assertTrue(doc != null);

		//		SecurityTokens st=ExampleService.getLastCallSecurityTokens();
		//		assertNotNull(st);
		//		
		//		String gamlAssertion = (String)st.getContext().get(GAMLAssertionInHandler.GENII_GAMLASSERTION_REF);
		//		assertTrue(gamlAssertion.contains("calling-context"));

		//		// now test with an invalid assertion
		//		try {
		//			example.getTime(in);
		//			throw new Error("This assertion should have been rejected!");
		//		} catch (Exception e) {
		//			// assertion rejected as expected
		//		}

		// from now on, expiration will be checked
		Mockit.tearDownMocks();

		// now test rejection of expired assertions
		try {
			example.getTime(in);
			throw new Error("This assertion should have been rejected!");
		} catch (Exception e) {
			System.out.println("Expired assertion rejected as expected!");
		}
	}

	@AfterClass
	public static void stopServer(){
		Kernel.getKernel().shutdown();
	}






}





