package eu.unicore.genii.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;

import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.addressing.AddressingOutHandler;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.handler.Phase;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

import de.fzj.unicore.uas.util.LogUtil;

public class GamlAssertionOutHandler extends AbstractHandler {

	private static final Logger logger = LogUtil.getLogger(LogUtil.SECURITY, GamlAssertionOutHandler.class);

	private static XMLOutputter o;
	private static int counter = 0;

	public GamlAssertionOutHandler() throws Exception {
		super();
		setPhase(Phase.POLICY);
		o = new XMLOutputter();
		o.setFormat(Format.getPrettyFormat());
		after(AddressingOutHandler.class.getName());
		init();
	}

	public void init() throws Exception{

	}

	@Override
	public void invoke(MessageContext context) throws Exception {
		String assertionFileName = null;

//		if(counter == 1)
//		{
//			assertionFileName = "src/test/resources/Invalid-calling-context.xml";
//		}
		if(counter == 1)
		{
			assertionFileName = "src/test/resources/Expired-calling-context.xml";
		}
		else
		{
			assertionFileName = "src/test/resources/Gaml-calling-context.xml";
		}
		counter ++;
		byte[] bytes = FileUtils.readFileToByteArray(new File(assertionFileName));

		Element gamlAssertionAsJDom = new SAXBuilder().build(new ByteArrayInputStream(bytes)).detachRootElement();
		Element h = context.getOutMessage().getOrCreateHeader();
		h.addContent((Element)gamlAssertionAsJDom.clone());
		if(logger.isDebugEnabled()){
			ByteArrayOutputStream bos=new ByteArrayOutputStream();
			new XMLOutputter(Format.getPrettyFormat()).output(gamlAssertionAsJDom, bos);
			logger.debug(bos.toString());
		}
	}

	public String getSoapHeaderAsString() throws Exception{
	String	assertionFileName = "src/test/resources/Gaml-calling-context.xml";
		byte[] bytes = FileUtils.readFileToByteArray(new File(assertionFileName));
		ByteArrayOutputStream bos=new ByteArrayOutputStream();
		Element gamlAssertionAsJDom = new SAXBuilder().build(new ByteArrayInputStream(bytes)).detachRootElement();
		new XMLOutputter(Format.getPrettyFormat()).output(gamlAssertionAsJDom, bos);
		return bos.toString();
	}


}
