package eu.unicore.genii.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

import edu.virginia.vcgr.genii.client.security.SecurityUtils;
import eu.unicore.security.util.client.AuthSSLProtocolSocketFactory.DummyTrustManager;

/**
 * helper code to create a truststore from pem files
 * 
 * @author schuller
 */
public class TruststoreUtil {

	private static int counter=0;


	public static KeyStore loadTruststoreFromPemFile(String name) throws IOException,NoSuchAlgorithmException,CertificateException,KeyStoreException {
		KeyStore trustStore= KeyStore.getInstance("jks");
		trustStore.load(null, "unicore".toCharArray());
		loadPemFile(name,trustStore);
		return trustStore;
	}


	public static KeyStore loadTruststoreFromDirectory(String name) throws IOException,NoSuchAlgorithmException,CertificateException,KeyStoreException {
		KeyStore trustStore= KeyStore.getInstance("jks");
		trustStore.load(null, "unicore".toCharArray());
		File directory=new File(name);
		File[] pems=directory.listFiles(new FilenameFilter(){
			public boolean accept(File f, String name){
				return name.endsWith(".pem") || name.endsWith(".cert");
			}
		});
		if(pems!= null)
		{
			for(File pem: pems){
				loadPemFile(pem.getAbsolutePath(),trustStore);
			}
		}
		return trustStore;
	}

	//load all the certs from the given pem file and put them as trusted certs into the keystore
	public static void loadPemFile(String name, KeyStore ks)throws IOException, KeyStoreException, CertificateException{
		CertificateFactory cf=CertificateFactory.getInstance("X.509");
		BufferedInputStream bis=new BufferedInputStream(new FileInputStream(name));
		try{
			while(bis.available() > 10){
				try {
					X509Certificate cert=(X509Certificate)cf.generateCertificate(bis);
					String dn=cert.getSubjectX500Principal().toString();
					ks.setCertificateEntry("trusted-"+counter, cert);
					counter++;

				} catch (CertificateException e) {
					break;
				}

			}
		}
		finally{
			try{bis.close();}catch(IOException io){};
		}
	}

	public static boolean isFromTrustedAuthority(KeyStore trustStore, X509Certificate... certChain)
	{
		if(certChain == null) return false;
		try {
			PKIXBuilderParameters pkixParams =
				new PKIXBuilderParameters(trustStore,
						new X509CertSelector());
			pkixParams.setRevocationEnabled(false);
			ManagerFactoryParameters trustParams =
				new CertPathTrustManagerParameters(pkixParams);
			TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
			tmf.init(trustParams);
			X509TrustManager trustManager = (X509TrustManager) tmf.getTrustManagers()[0];
			
			trustManager.checkClientTrusted(
					certChain,
					certChain[0].getPublicKey().getAlgorithm());
			return true;
		}
		catch (Exception e) {
			return false;
		}

	}



}
