package eu.unicore.genii.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class GenesisClientProperties {
	
	private X509Certificate certificate;
	
	private PrivateKey privateKey;
	
	public GenesisClientProperties(X509Certificate certificate,
			PrivateKey privateKey) {
		super();
		this.certificate = certificate;
		this.privateKey = privateKey;
	}
	
	public X509Certificate getCertificate() {
		return certificate;
	}
	public void setCertificate(X509Certificate certificate) {
		this.certificate = certificate;
	}
	public void setPrivateKey(PrivateKey privateKey) {
		this.privateKey = privateKey;
	}

	
	public void writeIdentity(KeyStore keystore, String alias, String password) throws KeyStoreException
	{
		alias = alias.toLowerCase();
		keystore.setKeyEntry(alias, privateKey, password.toCharArray(), new Certificate[]{certificate});
	}
}
