/*********************************************************************************
 * Copyright (c) 2006 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 ********************************************************************************/

package eu.unicore.genii.gffs;

import java.net.URI;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IFileTransferCreator;
import eu.unicore.genii.GenesisConstants;
import eu.unicore.security.Client;

/**
 * Create transfers that use FTP (via the java.net.URL class) or GSIFTP 
 * as filetransfer mechanism<br/>
 * 
 * @author schuller
 */
public class GFFSTransferCreator implements IFileTransferCreator, GenesisConstants {


	private final Configuration configuration;

	public GFFSTransferCreator (Configuration config){
		this.configuration=config;
	}
	public IFileTransfer createFileTransfer(Action parent, URI source,
			URI target, DataStagingCredentials credentials) {
		return null;
	}

	public String getProtocol() {
		return GFFS_PROTOCOL_SCHEME;
	}


	public IFileTransfer createFileImport(Client client,
			String workingDirectory, URI source, String target,
			DataStagingCredentials credentials) {
		String scheme=source.getScheme();
		if(getProtocol().equalsIgnoreCase(scheme))
		{
			return new GFFSDownload(client,workingDirectory,source,target,configuration);
		}
		else return null;
	}

	public IFileTransfer createFileExport(Client client,
			String workingDirectory, String source, URI target,
			DataStagingCredentials credentials) {
		String scheme=target.getScheme();
		if(getProtocol().equalsIgnoreCase(scheme))
		{
			return new GFFSUpload(client,workingDirectory,source,target,configuration);
		}
		else return null;
	}

}
