package eu.unicore.genii.gffs;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.io.IFileTransfer.Status;
import de.fzj.unicore.xnjs.io.simple.AsyncFilemover;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.fzj.unicore.xnjs.util.Observer;
import eu.unicore.genii.GenesisConstants;
import eu.unicore.security.Client;

public abstract class GFFSTransfer extends AsyncFilemover implements IFileTransfer,Observer<XnjsFile>, GenesisConstants {

	protected String stateDir;
	
	
	public GFFSTransfer(Client client, String workingDirectory, String source,
			String target, Configuration config) {
		super(client, workingDirectory, source, target, config);
	}
	

	public OverwritePolicy getOverwritePolicy() {
		return overwrite;
	}

	protected void preSubmit()throws Exception{
		try{


			ach.setEnvironmentVariable(GENII_USER_DIR_VARIABLE, stateDir);
		}catch(Exception ex){
			status=Status.FAILED;
			LogUtil.logException("Could not do GFFS transfer",ex,logger);
		}

	}
	
	public String getProtocol(){
		return "rns";
	}

	@Override
	public long getDataSize() {
		return -1;
	}
}
