package eu.unicore.genii.gffs;

import java.util.ServiceLoader;

import de.fzj.unicore.xnjs.io.IFileTransferCreator;
import de.fzj.unicore.xnjs.io.IOCapabilities;


/**
 * This class is used register the GFFS file transfer creator for handling
 * GFFS transfers in the JSDL.
 * It is hooked in via the {@link ServiceLoader} facility.
 * @author bdemuth
 *
 */
public class GFFSIOCapabilities implements IOCapabilities {

	@Override
	@SuppressWarnings("unchecked")
	public Class<? extends IFileTransferCreator>[] getFileTransferCreators() {
		return new Class[]{
				GFFSTransferCreator.class,
		};
	}

}
