/*********************************************************************************
 * Copyright (c) 2008 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *********************************************************************************/


package eu.unicore.genii.gffs;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.io.IFileTransfer.OverwritePolicy;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.util.AsyncCommandHelper;
import de.fzj.unicore.xnjs.util.FileMonitor;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.fzj.unicore.xnjs.util.ResultHolder;
import eu.unicore.genii.security.CreateStateDirResult;
import eu.unicore.genii.security.TrustDelegationUtils;
import eu.unicore.security.Client;

/**
 * gffs file import implementation
 * 
 * 
 * @author demuth
 */
public class GFFSDownload extends GFFSTransfer implements IFileTransfer {


	public GFFSDownload(Client client, String workingDirectory, URI source,
			String target, Configuration config) {
		super(client, workingDirectory, source.toString(), target, config);
	}


	protected void preSubmit()throws Exception{
		try{
			ach.setEnvironmentVariable(GENII_USER_DIR_VARIABLE, stateDir);
		}catch(Exception ex){
			status=Status.FAILED;
			LogUtil.logException("Could not do GFFS download",ex,logger);
		}


	}

	@Override
	protected String makeCommandline() throws Exception {
		Action action=configuration.getInternalManager().getAction(getParentActionID());
		CreateStateDirResult result = TrustDelegationUtils.createGenIIStateDirIfNotExists(configuration, action);

		TSI tsi = configuration.getTargetSystemInterface(client);
		String tsiFilesep = tsi.getFileSeparator();

		String target = workingDirectory+tsiFilesep+this.target;
		stateDir = result.stateDirPath;

		String installationPath = UAS.getProperty(PROP_GENII_INSTALLATION_PATH_TSI);
		if(installationPath == null)
		{
			installationPath = configuration.getIDB().getProperty(PROP_GENII_INSTALLATION_PATH_TSI,null);
		}
		if(installationPath == null) installationPath = "";

		String executable = UAS.getProperty(PROP_GENII_EXECUTABLE);
		if(executable == null)
		{
			executable = configuration.getIDB().getProperty(PROP_GENII_EXECUTABLE,null);
		}
		if(executable == null) executable = GENII_EXECUTABLE;

		String params = "";

		String cmd = "";
		if(OverwritePolicy.OVERWRITE.equals(getOverwritePolicy()))
		{
			cmd += installationPath + tsiFilesep + executable+" cp "+params+" '"+source+"' 'local:"+target+"'";

		}
		else if(OverwritePolicy.DONT_OVERWRITE.equals(getOverwritePolicy()))
		{
			//			params += " -n";
			cmd += installationPath + tsiFilesep + executable+" cp "+params+" '"+source+"' 'local:"+target+"'";
		}
		logger.debug("Calling Genesis grid command: "+cmd);
		return cmd;
	}

	@Override
	protected boolean isImport() {
		return true;
	}


	
}
