/*********************************************************************************
 * Copyright (c) 2006 Forschungszentrum Juelich GmbH 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * (1) Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer at the end. Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 * 
 * (2) Neither the name of Forschungszentrum Juelich GmbH nor the names of its 
 * contributors may be used to endorse or promote products derived from this 
 * software without specific prior written permission.
 * 
 * DISCLAIMER
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *********************************************************************************/


package eu.unicore.genii.env;

import org.apache.log4j.Logger;

import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.processors.DefaultProcessor;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.util.LogUtil;
import edu.virginia.vcgr.genii.client.context.ICallingContext;
import eu.unicore.genii.GenesisConstants;
import eu.unicore.genii.security.TrustDelegationUtils;
import eu.unicore.security.Client;

/**
 * If available read in Genesis II security tokens and create a state directory
 * containing a new key that we delegate to. This allows user applications to
 * use the Genesis client to access Grid resources.
 * 
 * @author 
 * demuth
 */
public class GenesisTrustDelegationProcessor extends DefaultProcessor implements GenesisConstants {

	public GenesisTrustDelegationProcessor(Configuration configuration) {
		super(configuration);
	}

	private static final Logger logger=LogUtil.getLogger(LogUtil.JOBS,GenesisTrustDelegationProcessor.class);

	protected void handleCreated()
	{
		
		try{
			Client client=action.getClient();
			ICallingContext context =(ICallingContext) client.getSecurityTokens().getContext().get(GENII_GAMLASSERTION_REF);
			if(context==null){
				// can't operate without the context
				return;
			}
			
			String stateDir = TrustDelegationUtils.createGenIIStateDirIfNotExists(configuration, action).stateDirPath;
			ApplicationInfo appInfo = action.getApplicationInfo();
			
			String installationPath = UAS.getProperty(PROP_GENII_INSTALLATION_PATH_TSI);
			if(installationPath == null)
			{
				installationPath = configuration.getIDB().getProperty(PROP_GENII_INSTALLATION_PATH_TSI,null);
			}
			if(installationPath == null) installationPath = "";
			
			appInfo.getEnvironment().put(GENII_BIN_DIR_VARIABLE,installationPath);
			appInfo.getEnvironment().put(GENII_USER_DIR_VARIABLE,stateDir);
		}
		catch (Exception e) {
			logger.warn("Failure creating Genesis II state directory.",e);
		
		}
	}
	
}