package eu.unicore.genii;

import java.io.File;

import org.jdom.Namespace;


import eu.unicore.genii.security.GAMLAssertionInHandler;

public interface GenesisConstants {
	
	/**
	 * Name-space of a GAML Assertion 
	 */
	public static final Namespace GENII_NS=Namespace.getNamespace("http://vcgr.cs.virginia.edu/Genesis-II");
	
	public static final String GENII_BES_NS =
		"http://vcgr.cs.virginia.edu/genii/2008/3/bes";
	
	/**
	 * Element name of a GAML Assertion 
	 */
	public static final String GENII_GAMLASSERTION="calling-context";

	public static final String GENII_GAMLASSERTION_REF=GAMLAssertionInHandler.class.getName()+"-CallingContext";
	
	/**
	 * Protocol scheme identifying GFFT stagings in job descriptions (JSDL)
	 */
	public static final String GFFS_PROTOCOL_SCHEME = "rns";
	
	/**
	 * Name of the Genesis II comandline tool
	 */
	public static final String GENII_EXECUTABLE="grid";
	
	
	/**
	 * Name of the Genesis II state directory
	 */
	public static final String GENII_STATE_DIR=".genState";
	
	
	public static final String USER_CONTEXT_FILENAME =
		"user-context.xml";
	public static final String USER_TRANSIENT_FILENAME =
		"user-transient.dat";
	public static final String COMBINED_FILENAME =
		"user-combined.xml";
	
	/**
	 * Name of the Genesis II variable defining the state directory
	 */
	public static final String GENII_USER_DIR_VARIABLE="GENII_USER_DIR";

	public static final String GENII_BIN_DIR_VARIABLE="GENII_BIN_DIR";
	
	/**
	 * Property for setting the path to the GenII grid executable at the TSI
	 */
	public static final String PROP_GENII_INSTALLATION_PATH_TSI="genii.client.dir.tsi";
	
	public static final String PROP_GENII_EXECUTABLE="genii.client.executable";
	
	public static final String PROP_TRUSTED_ID_PROVIDER_DIR = "genii.trusted.dir";
	
	public static final String DEFAULT_TRUSTED_ID_PROVIDER_DIR = "conf"+File.separator+"trustedIdentityProviders";
	
	public static final String PROP_DELEGATION_KEYLENGTH = "genii.delegation.keylength";
	
	public static final String PROP_VALID_ORGANISATION_PATTERNS = "genii.organisation.patterns";
	
	public static final String PROP_VALID_USER_NAME_PATTERNS = "genii.user.name.patterns";
	
}

