package eu.unicore.genii;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

import javax.xml.namespace.QName;

import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

import de.fzj.unicore.bes.impl.activity.BESActivityHomeImpl;
import de.fzj.unicore.bes.impl.factory.BESFactoryHomeImpl;
import de.fzj.unicore.bes.impl.management.BESManagementImpl;
import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.security.SkipSignatureCheckInHandler;
import de.fzj.unicore.xnjs.beans.engine.EngineConfigurationDocument;
import de.fzj.unicore.xnjs.beans.engine.ProcessingChainDocument.ProcessingChain;
import eu.unicore.genii.env.GenesisTrustDelegationProcessor;
import eu.unicore.genii.security.GAMLAssertionInHandler;

public class ConfigureUnicoreForGenesis implements GenesisConstants {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		if(args.length < 2) System.err.println("Wrong number of arguments supplied, usage: ConfigureUnicoreForGenesis uas.configPath genesisInstallationPath");
		String uasConfig = args[0];
		String geniiPath = args[1];
		if(uasConfig == null || uasConfig.trim().length() == 0)
		{
			System.err.println("No main UNICORE config file given... quitting.");
			return;
		}
		File uasConfigFile = new File(uasConfig);
		Properties uasProps = new Properties();
		try {
			uasProps.load(new FileReader(uasConfigFile));
		} catch (FileNotFoundException e) {
			System.err.println("File "+uasConfigFile.getAbsolutePath()+" could not be found!");
			return;
		} catch (IOException e) {
			System.err.println("File "+uasConfigFile.getAbsolutePath()+" could not be read!");
			return;
		}


		String wsrfConf = uasProps.getProperty(UAS.WSRFLITE_CONFIG);
		XmlObject wsrf = addHandlersToWSRFConfig(wsrfConf);
		saveWSRFConfig(wsrfConf, wsrf);

		String xnjsConf = uasProps.getProperty(UAS.TSF_XNJS_CONFIGFILE);
		XmlObject xnjs = addTDProcessorToXNJSConfig(xnjsConf);
		saveXNJSConfig(xnjsConf, xnjs);

		if(uasProps.containsKey(PROP_GENII_INSTALLATION_PATH_TSI))
		{
			System.out.println("Genesis client path already set (see "+PROP_GENII_INSTALLATION_PATH_TSI+" property in file "+uasConfigFile.getAbsolutePath()+") changing the value...");
			try {
				BufferedReader reader = new BufferedReader(new FileReader(uasConfigFile));
				String line = "", oldtext = "";
				while((line = reader.readLine()) != null)
				{
					oldtext += line + "\r\n";
				}
				reader.close();
				// replace 
				String newtext = oldtext.replaceAll(PROP_GENII_INSTALLATION_PATH_TSI+"\\s*=\\s*\\S*\\s*", PROP_GENII_INSTALLATION_PATH_TSI+"="+geniiPath);
				FileWriter writer = new FileWriter(uasConfigFile);
				writer.write(newtext);writer.close();
			} catch (Exception e) {
				System.err.println("Value could not be replaced in file "+uasConfigFile.getAbsolutePath()+"!");
			}
		}

		else
		{
			try {
				System.out.println("Trying to set the Genesis client path correctly in file "+uasConfigFile.getAbsolutePath()+"...");
				FileWriter uasWriter = new FileWriter(uasConfigFile, true);
				uasWriter.write("#########################################################################\n");
				uasWriter.write("##################### Genesis II related Properties #####################\n");
				uasWriter.write("#########################################################################\n\n");

				uasWriter.write("# Path of the Genesis client executable on the TSI host:\n");
				uasWriter.write(PROP_GENII_INSTALLATION_PATH_TSI+"="+ geniiPath);
				uasWriter.flush();
				System.out.println("done.");

			} catch (Exception e) {
				System.err.println("File "+uasConfigFile.getAbsolutePath()+" could not be written to!");
			}
		}

	}

	protected static XmlObject addHandlersToWSRFConfig(String wsrfConf)
	{
		XmlObject wsrf = null;
		boolean fileChanged = false;
		try {
			System.out.println("Trying to add security handlers in file "+wsrfConf);
			wsrf = XmlObject.Factory.parse(new FileReader(wsrfConf));
			XmlObject[] services = wsrf.selectChildren(new QName("services"))[0].selectChildren(new QName("service"));
			if(services != null && services.length > 0)
			{
				for(XmlObject service : services)
				{


					XmlCursor cursor = service.newCursor();

					if(!cursor.toChild("implementation")) continue;
					try {
						String clazz = cursor.getAttributeText(new QName("class"));
						// don't add handlers twice
						if(service.xmlText().contains(GAMLAssertionInHandler.class.getCanonicalName()))
						{
							System.out.println("Security handler for service implementation "+clazz+" already set, skipping this step.");
							continue;
						}
						if(clazz != null && (clazz.contains(BESFactoryHomeImpl.class.getCanonicalName())
								|| clazz.contains(BESActivityHomeImpl.class.getCanonicalName())
								|| clazz.contains(BESManagementImpl.class.getCanonicalName())))
						{
							try {
								fileChanged = true;
								cursor.toEndToken();
								cursor.toNextToken();
								cursor.beginElement("handler");

								cursor.insertAttributeWithValue("type", "in");
								cursor.insertAttributeWithValue("class", GAMLAssertionInHandler.class.getCanonicalName());

								if(clazz.contains(BESActivityHomeImpl.class.getCanonicalName()))
								{
									cursor.toEndToken();
									cursor.toNextToken();
									cursor.beginElement("handler");

									cursor.insertAttributeWithValue("type", "in");
									cursor.insertAttributeWithValue("class", SkipSignatureCheckInHandler.class.getCanonicalName());
								}

							} catch (Exception e2) {
								System.err.println("Problem while adding security handler to service implementation class "+clazz);
							}
						}
					} catch (Exception e2) {
						System.err.println("Problem while reading service implementation "+cursor.xmlText());
					}
					finally
					{
						cursor.dispose();
					}

				}
			}
			else {
				System.err.println("Could not find OGSA-BES services! Genesis II clients will not be able to submit jobs to this UNICORE installation.");
			}
		} catch (Exception e) {
			System.err.println("File "+wsrfConf+" could not be read!");
		}
		if(fileChanged)
		{

			System.out.println("done.");
			return wsrf;
		}
		return null;
	}

	protected static void saveWSRFConfig(String wsrfConf, XmlObject wsrf)
	{
		if(wsrf != null)
		{
			File f = new File(wsrfConf);
			try {
				System.out.println("Trying to save "+f.getAbsolutePath()+"...");
				wsrf.save(f);
				System.out.println("done.");
			} catch (Exception e) {
				System.err.println("File "+f.getAbsolutePath()+" could not be written!");
			}
		}
	}

	protected static void saveXNJSConfig(String xnjsConf, XmlObject xnjs)
	{
		if(xnjs != null)
		{
			File f = new File(xnjsConf);
			try {
				System.out.println("Trying to save "+f.getAbsolutePath()+"...");
				xnjs.save(f);
				System.out.println("done.");
			} catch (Exception e) {
				System.err.println("File "+f.getAbsolutePath()+" could not be written!");
			}
		}
	}

	protected static XmlObject addTDProcessorToXNJSConfig(String xnjsConf)
	{
		try {

			EngineConfigurationDocument xnjs = EngineConfigurationDocument.Factory.parse(new FileReader(xnjsConf));
			// don't add processor twice
			if(xnjs.xmlText().contains(GenesisTrustDelegationProcessor.class.getCanonicalName()))
			{
				System.out.println("Genesis processor "+GenesisTrustDelegationProcessor.class.getCanonicalName()+" already added, skipping this step.");
				return null;
			}
			System.out.println("Trying to add Genesis job processor in file "+xnjsConf);

			for(ProcessingChain chain : xnjs.getEngineConfiguration().getProcessingChainArray())
			{
				if("jsdl".equalsIgnoreCase(chain.getActionType()))
				{
					chain.addNewProcessor().setStringValue(GenesisTrustDelegationProcessor.class.getCanonicalName());
					System.out.println("done.");
					return xnjs;
				}
			}

		} catch (Exception e) {
			System.err.println("File "+xnjsConf+" could not be read!");
		}
		System.err.println("Could not add Genesis job processor...");
		return null;
	}

}
