package edu.virginia.vcgr.genii.security;

import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.security.auth.x500.X500Principal;


public class X500PrincipalUtilities
{
	
	static final private Pattern ATTRIBUTE_PATTERN = Pattern.compile("([^=]+)=([^=]+)");
	
	static final private Pattern cnExtractor = Pattern.compile(
		"^.*[cC][nN]=([^,]+),.*$");
	
	static private String getCN(X500Principal principal)
	{
		Matcher matcher = cnExtractor.matcher(principal.getName(
			X500Principal.RFC1779));
		if (!matcher.matches())
			return principal.getName(X500Principal.RFC1779);
		
		return matcher.group(1);
	}
	
	static public String describe(X500Principal principal, 
		VerbosityLevel verbosity)
	{
		if (principal == null)
			return "(no principal)";
		
		if (verbosity.compareTo(VerbosityLevel.HIGH) >= 0)
			return principal.toString();
		else
			return String.format("\"%s\"",
				getCN(principal));
	}
	
	public static String getCanonicalizedString(X500Principal principal)
	{
		String canonical = principal.getName(X500Principal.CANONICAL);
		

		String[] tokens = canonical.split("[^\\\\],");
		Arrays.sort(tokens, new Comparator<String>() {

			@Override
			public int compare(String o1, String o2) {
				Matcher m1 = ATTRIBUTE_PATTERN.matcher(o1);
				m1.matches();
				Matcher m2 = ATTRIBUTE_PATTERN.matcher(o2);
				m2.matches();
				int result = m1.group(1).compareTo(m2.group(1));
				if(result != 0) return result;
				else return m1.group(2).compareTo(m2.group(2));
			}
		});
		StringBuffer buff = new StringBuffer();
		for(int i = 0; i < tokens.length;i++)
		{
			String s = tokens[i];

			if(buff.length()>0) buff.append(",");
			buff.append(s);

		}
		return buff.toString();
	}

}