package de.pc2.unicore.edgi;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.client.JobClient;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.xnjs.Configuration;
import de.pc2.unicore.edgi.idb.ApplicationRepository;
import de.pc2.unicore.edgi.idb.ApplicationRepository.App;
import de.pc2.unicore.edgi.idb.ApplicationRepository.Impl;
import eu.unicore.bugsreporter.annotation.FunctionalTest;

public class TestRun extends AbstractJobRun{

	EndpointReferenceType tssepr;
	
	@Override
	@FunctionalTest(id="RunDateTest", description="Runs a 'date' job.")
	public void testRunJob()throws Exception{
		//manually add an application to the App repository
		Configuration config=XNJSFacade.get(null, kernel).getConfiguration();
		ApplicationRepository ar=config.getComponentInstanceOfType(ApplicationRepository.class);
		App a=new App("1000", "Date");
		Impl i=new Impl("1001");
		ar.addImpl(a, i);
		super.testRunJob();
	}

	@Override
	protected JobDefinitionDocument getJob() {
		JobDefinitionDocument jdd=JobDefinitionDocument.Factory.newInstance();
		ApplicationType app=jdd.addNewJobDefinition().addNewJobDescription().addNewApplication();
		app.setApplicationName("Date");
		app.setApplicationVersion("1.0");
		return jdd;
	}
	
	@Override
	protected void beforeStart(JobClient job)throws Exception{
		System.out.println("Job submitted at: "+job.getSubmissionTime());
	}
	
	@Override
	protected void onFinish(JobClient job) throws Exception{
		System.out.println(job.getResourcePropertyDocument());
		if(doDestroy())job.destroy();
	}

	protected boolean doDestroy(){
		return true;
	}

}
