package de.pc2.unicore.edgi;

import java.io.File;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import de.fzj.unicore.uas.UAS;
import de.fzj.unicore.uas.UASProperties;
import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.uas.util.CreateSMSOnStartup;
import de.fzj.unicore.wsrflite.Kernel;

/**
 * base class for functional tests. Starts a "clean" UNICORE/X server.
 */
public abstract class Base{

	static final String configPath="src/test/resources/uas.config";
	
	public static void initDirectories() {
		//clear data directory
		FileUtils.deleteQuietly(new File("target","data"));
		File testsRoot = new File("target", "unicorex-test");
		FileUtils.deleteQuietly(testsRoot);
		testsRoot.mkdirs();
	}
	
	protected static UAS uas;
	protected static Kernel kernel;
	
	@BeforeClass
	public static void startUNICORE() throws Exception{
		
		//tell loggers to shut up during startup phase
		Level l=Logger.getRootLogger().getLevel();
		Logger.getRootLogger().setLevel(Level.INFO);
		
		long start=System.currentTimeMillis();
		System.out.println("Starting UNICORE/X...");
		
		initDirectories();
		uas=new UAS(configPath);
		kernel=uas.getKernel();
		
		//make default_SMS workdir absolute 
		UASProperties uasProperties = kernel.getAttribute(UASProperties.class); 
		String smsPath=uasProperties.getValue(UASProperties.DEFSMS_WORKDIR);
		if(smsPath!=null){
			uasProperties.setProperty(UASProperties.DEFSMS_WORKDIR, new File(smsPath).getAbsolutePath());
		}

		uas.startSynchronous();
		
		System.err.println("UNICORE/X startup time: "+(System.currentTimeMillis()-start)+" ms.");
		
		//create a "default" SMS
		new CreateSMSOnStartup(kernel).run();
		Logger.getRootLogger().setLevel(l);
	}

	@AfterClass
	public static void stopUNICORE() throws Exception{
		kernel.shutdown();
	}
	
	protected EndpointReferenceType findFirstAccessibleService(List<EndpointReferenceType>eprs){
		for(EndpointReferenceType epr: eprs){
			try{
				BaseUASClient c=new BaseUASClient(epr,uas.getKernel().getClientConfiguration());
				c.getCurrentTime();
				return epr;
			}catch(Exception e){}
		}
		return null;
	}
}
