package de.pc2.unicore.edgi.xnjs.io.passthrough;

import java.net.URI;
import java.net.URISyntaxException;

public class URIComposed {
	public URI uri;
	public String md5;
	public long size;
	
	public URIComposed(URI uri) {
		this(uri, null, -1);
	}
	
	public URIComposed(URI uri, String md5, long size) {
		this.uri = uri;
		this.md5 = md5;
		this.size = size;
	}
	
	public String toString() {
		return this.uri.toString() + "  (md5="+this.md5+", size="+this.size+")";
	}
	
	public String toComposed() {
		StringBuilder sb = new StringBuilder();
		sb.append(this.uri.toString());
		if (this.md5 != null) {
			sb.append("=");
			sb.append(this.md5);
		}
		if (this.size > 0 ) {
			if (this.md5 == null) {
				sb.append("=");
			}
			sb.append("=");
			sb.append(String.valueOf(this.size));
		}
		return sb.toString();
	}
	
	public boolean hasMD5andSize() {
		return this.md5 != null && this.size > 0;
	}
	
	public URI toOuterURI(String scheme) throws URISyntaxException {
		String x = scheme + "://" + this.toComposed();
		return new URI(x);
	}
	
	
	static public URIComposed fromOuterURI(URI org_uri) throws URISyntaxException,NumberFormatException {
		return URIComposed.fromOuterURI(org_uri, true);
	}
	
	static public URIComposed fromOuterURI(URI org_uri, boolean enforce_md5_size) throws URISyntaxException,NumberFormatException {
		URIComposed r = new URIComposed(org_uri);
		
		String s = org_uri.getSchemeSpecificPart();
		// remove leading /  (variations of from "xxx:" to "xxx:///")
		int idx = 0;
		while (s.charAt(idx) == '/') { idx += 1; }
		s = s.substring(idx);
		// split uri=md5=size
		String[] splits = s.split("=", 3);
		
		if (splits.length == 0) {
			throw new URISyntaxException(s, "can't find uri part in composed uri.");
		}
		
		r.uri = new URI(splits[0]);
		
		if (splits.length >= 2) {
			r.md5 = splits[1];
			if (r.md5.length() == 0)
				r.md5 = null;
		} else {
			if (enforce_md5_size) {
				throw new URISyntaxException(s, "can't find md5 part in composed uri.");
			}
		}
		
		if (splits.length >= 3) {
			String size = splits[2];
			r.size = (new Long(size)).longValue();
		} else {
			// splits has only uri,md5
			if (enforce_md5_size) {
				throw new URISyntaxException(s, "can't find size part in composed uri.");
			}
		}
		
		return r;
		
		
		
		
		
		
		
	}
	
}
