package de.pc2.unicore.edgi.xnjs.io.passthrough;



import java.net.URI;

import de.fzj.unicore.xnjs.Configuration;
import eu.unicore.security.Client;

public class PassthroughUpload extends PassthroughTransferBase{
	
	private final String source;
	private final URI target;
	
	public PassthroughUpload(Configuration configuration, Client client, String source, URI target){
		super(configuration,client);
		this.source=source;
		this.target=target;
	}

	@Override
	public long getDataSize() {
		return 0;
	}

	@Override
	public String getSource() {
		return source;
	}
	
	@Override
	public String getTarget() {
		return target.toString();
	}

	@Override
	public long getTransferredBytes() {
		return 0;
	}

	@Override
	public void run() {
		status=Status.DONE;
	}

	@Override
	public boolean isIgnoreFailure() {
		return true;
	}

	@Override
	public void setIgnoreFailure(boolean ignoreFailure) {
		// TODO Auto-generated method stub
		
	}

}