package de.pc2.unicore.edgi.xnjs.io.passthrough;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IStorageAdapter;
import de.fzj.unicore.xnjs.io.OptionNotSupportedException;
import de.fzj.unicore.xnjs.tsi.TSI;
import eu.unicore.security.Client;

public abstract class PassthroughTransferBase implements IFileTransfer{
	
	protected Status status;
	protected String statusMessage = null;	
	
	protected Configuration configuration;
	protected final Client client;
	protected final String uuid;
	protected OverwritePolicy overwrite;
	private String parentActionID;
	protected volatile boolean aborted=false;
	
	public PassthroughTransferBase(Configuration configuration, Client client){
		this.configuration=configuration;
		this.client=client;
		this.uuid=UUID.randomUUID().toString();
		status=Status.CREATED;
	}
	
	public boolean abort(){
		aborted=true;
		return true;
	}
	
	/*@Override*/
	public String getParentActionID() {
		return parentActionID;
	}

	@Override
	public Status getStatus() {
		return status;
	}

	@Override
	public String getStatusMessage() {
		return (this.statusMessage != null ? this.statusMessage : status.toString());
	}

	@Override
	public String getUniqueId() {
		return uuid;
	}

	@Override
	public boolean isStreaming() {
		return false;
	}

	@Override
	public Map<String, Serializable> pause() {
		//Not supported...
		return null;
	}

	@Override
	public void resume(Map<String, Serializable> status) {
		//Not supported... 
	}

	protected void ensureDirectoriesExist(String path)throws Exception{
		String dir=path.substring(0,path.lastIndexOf("/"));
		TSI tsi=configuration.getTargetSystemInterface(client);
		tsi.mkdir(dir);
	}
	
	protected StorageClient createStorageClient()throws Exception{
		//ISecurityProperties sec=Kernel.getKernel().getSecurityProperties().clone();
		//ETDAssertionForwarding.configureETD(client, sec);
		//String address=Kernel.getKernel().getProperty(XTREEMFS_REMOTE_URL);
		//if(address==null){
			//TODO check for an XtreemFS SMS in the external registry
		//	throw new IllegalStateException("No SMS for remote XtreemFS access is defined!");
		//}
		
		//EndpointReferenceType epr=EndpointReferenceType.Factory.newInstance();
		//epr.addNewAddress().setStringValue(address);
		//StorageClient sms=new StorageClient(epr,sec);
		//return sms;
		return null;
	}
	
	@Override
	public void setOverwritePolicy(OverwritePolicy overwrite)
			throws OptionNotSupportedException {
		this.overwrite=overwrite;
	}

	/*@Override*/
	public void setParentActionID(String actionID) {
		this.parentActionID=actionID;
	}

	@Override
	public void setStorageAdapter(IStorageAdapter adapter) {

	}
	
	/*@Override*/
	public String getProtocol() {
		return PassthroughCapabilities.SCHEME;
	}
	
}