package de.pc2.unicore.edgi.xnjs.io.passthrough;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

import org.apache.log4j.Logger;

import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.io.DataStagingCredentials;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IFileTransfer.OverwritePolicy;
import de.fzj.unicore.xnjs.io.IFileTransferCreator;
import eu.unicore.security.Client;

public class PassthroughFileTransferCreator implements IFileTransferCreator {
	
	private static final Logger logger = LogUtil.getLogger(LogUtil.SERVICES, PassthroughFileTransferCreator.class);
	
	private Configuration configuration;
	
	public PassthroughFileTransferCreator(Configuration configuration){
		this.configuration=configuration;
	}
	
	@Override
	public IFileTransfer createFileExport(Client client,
			String workingDirectory, String source, URI target,
			DataStagingCredentials credentials) 
	{
		if(PassthroughCapabilities.isValidUri(target)){
			boolean invalidFormat = false;
			URIComposed uric = null;
			try {
				uric = URIComposed.fromOuterURI(target, false);
			} catch (NumberFormatException e1) {
				logger.error("passthrough invalid format: "+target, e1);
				invalidFormat = true;
			} catch (URISyntaxException e1) {
				logger.error("passthrough invalid format: "+target, e1);
				invalidFormat = true;
			} 
			if (invalidFormat || !uric.hasMD5andSize()){
				logger.info("passthrough deactivated because not enough parameter given. expected pass://URI=MD5=size. fallback: try to stage in from inner URI.");
				IFileTransfer ft = null;
				try {
					ft = this.configuration.getFileTransferEngine().createFileExport(client, workingDirectory, 
							source, uric.uri, OverwritePolicy.DONT_OVERWRITE /*will be overwritten*/, credentials);
				} catch (IOException e) {
					logger.error("ignored execption while searching for file import for inner URI: "+uric.uri, e);
				}
				return ft;
			}
			logger.debug("detect passthrough url = " + uric.toString());		
			return new PassthroughUpload(configuration,client,source,target);
		}
		return null;		
	}

	@Override
	public IFileTransfer createFileImport(Client client,
			String workingDirectory, URI source, String target,
			DataStagingCredentials credentials) 
	{
		if(PassthroughCapabilities.isValidUri(source)){
			boolean invalidFormat = false;
			URIComposed uric = null;
			try {
				uric = URIComposed.fromOuterURI(source, false);
			} catch (NumberFormatException e1) {
				logger.error("passthrough invalid format: "+source, e1);
				invalidFormat = true;
			} catch (URISyntaxException e1) {
				logger.error("passthrough invalid format: "+source, e1);
				invalidFormat = true;
			} 
			if (invalidFormat || !uric.hasMD5andSize()){
				logger.info("passthrough deactivated because not enough parameter given. expected pass://URI=MD5=size. fallback: try to stage in from inner URI.");
				IFileTransfer ft = null;
				try {
					ft = this.configuration.getFileTransferEngine().createFileImport(client, workingDirectory,
							uric.uri, target, OverwritePolicy.DONT_OVERWRITE /*will be overwritten*/, credentials);
				} catch (IOException e) {
					logger.error("ignored execption while searching for file import for inner URI: "+uric.uri, e);
				}
				return ft;
			}
			logger.debug("detect passthrough url = " + uric.toString());		
			return new PassthroughDownload(configuration,client,source,target);
		}
		return null;
	}

	//@Override
	public IFileTransfer createFileTransfer(Action parent, URI source, URI target) {
		return null;
	}

	@Override
	public String getProtocol() {
		return PassthroughCapabilities.SCHEME;
	}

}
