package de.pc2.unicore.edgi.xnjs.io.passthrough;

import java.net.URI;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.IFileTransferCreator;
import de.fzj.unicore.xnjs.io.IFileTransferEngine;

/* this class is created in order to support new 1.4.2 service concept. */
public class PassthroughCapabilities /*extends IOCapabilities*/ {
	
	public static final String SCHEME = "bypass";
	
	/*@Override*/
	@SuppressWarnings("unchecked")
	public Class<? extends IFileTransferCreator>[] getFileTransferCreators() {
		return new Class[]{
				PassthroughFileTransferCreator.class,
		};
	}
	
	public static void register(Configuration conf) {
		IFileTransferEngine fte = conf.getFileTransferEngine();
		// check for registering once = protocol exists
		String[] protocols = fte.listProtocols();
		boolean already_registered = false;
		for (String protocol: protocols) {
			if (protocol.equals(SCHEME)) {
				already_registered = true;
				break;
			}
		}
		if (!already_registered) {
			fte.registerFileTransferCreator(new PassthroughFileTransferCreator(conf));
		}
		protocols = fte.listProtocols();
		
	}
	
	public static boolean isValidUri(URI uri) {
		return SCHEME.equalsIgnoreCase(uri.getScheme());
	}
	
	public static boolean isValidUri(String uri) {
		String scheme = uri.substring(0, SCHEME.length());
		return SCHEME.equalsIgnoreCase(scheme);
	}
}
