package de.pc2.unicore.edgi.xnjs.g3bridge;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;


public class JobDescription implements Serializable {
	
	private static final long serialVersionUID = 1L;

	public static enum Status {
		UNSET(-1), // this internal value is only for client-side, after new instance or after special commands
		UNKNOWN (0), // 3gbridge doesn't know the job
		INIT (1),
		RUNNING (2),
		FINISHED (3),
		ERROR (4), // 3gbridge report an error
		TEMPFAILED (5); // 3gbridge report another error
		private final int value;
		Status(int v){this.value = v;}
		public int value() { return value; }		
	}
	
	/*
	 * these are the initial data of a job
	 *   alg and grid is required and args, inputs, outputs optional
	 */
	public String alg;
	public String grid;
	public String args;
	public List<LogicalFileDescription> inputs;
	public List<LogicalFileDescription> outputs;
	public List<String> envs; // optional, unlimited env-specifications
	public String tag; // optional, null means not set
	
	/* 
	 * runtime data of a job, 
	 *   Id is set after submit and is needed for every command
	 *   Status has to be updated every time
	 *   ?output?
	 */
	public String id;
	public Status status;
	
	//public volatile boolean intern_scheduled_for_update = false;
	
	
	public JobDescription(
			String alg, 
			String grid, 
			String args, // optional (null/empty means unset) 
			List<LogicalFileDescription> inputs, // optional (null means unset)
			List<String> outputs, //optional only the logical-names for the application 
			List<String> envs, // optional (null/empty means unset)
			String tag // optional (null means unset)
	){
		this.alg = alg; this.grid = grid;
		this.args = (args != null) ? args : ""; 
		this.inputs = new ArrayList<LogicalFileDescription>();
		if (inputs != null) {
			for (LogicalFileDescription lfd: inputs) {
				this.inputs.add(lfd);
			}	
		} 
		this.outputs = new ArrayList<LogicalFileDescription>();
		if (outputs != null) {
			for (String name: outputs) {
				this.outputs.add(new LogicalFileDescription(name));
			}	
		} 
		this.envs = new ArrayList<String>();
		if (envs != null) {
			for (String env: envs) {
				this.envs.add(env);
			}
		}
		this.tag = tag;
		
		this.id = null;
		this.status = JobDescription.Status.UNSET;
	}
	
	public JobDescription(String id) {		
		this.alg = this.grid = null;
		this.args = null;
		this.inputs = null;
		this.outputs = null;
		this.envs = null;
		this.tag = null;
		
		this.id = id;
		this.status = JobDescription.Status.UNSET;	
	}
	
	public JobDescription(JobDescription other) {
		this.alg = other.alg;
		this.grid = other.grid;
		this.args = other.args;
		this.inputs = other.inputs;
		this.outputs = other.outputs;
		this.envs =  other.envs;
		this.tag = other.tag;
		
		this.id = other.id;
		this.status = other.status;
			
	}
	
	public String toString() {
		return this.id + ", " + this.status;
	}
	
	void println(PrintStream ps){
		ps.printf("JobID '%s' status '%s'\n", this.id, this.status);
		ps.printf("  Grid '%s', Alg '%s', Args '%s'\n", this.grid, this.alg, this.args);
		for (LogicalFileDescription lf: this.inputs) {
			ps.printf("  inputs name '%s', url '%s', md5 '%s', size '%d'\n", lf.logicalName, lf.url, lf.md5, lf.size);
		}
		for (LogicalFileDescription lf: this.outputs) {
			ps.printf("  outputs name '%s', url '%s', md5 '%s', size '%d'\n", lf.logicalName, lf.url, lf.md5, lf.size);
		}
		for (String lf: this.envs) {
			ps.printf("  envs '%s'\n", lf);
		}
		ps.printf("  tag '%s'", this.tag);
	}

}
