package de.pc2.unicore.edgi.xnjs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * A caching mechanism for file.absolutpath -> md5 
 * 
 * Limit: for this implementation, no check of update/modification and outdated-md5 of file
 * 
 * @author mkeller
 *
 */
public class XnjsFileDB {
	
	static public String computeMD5(String path) throws NoSuchAlgorithmException, IOException {
		File file = new File(path);
		final int BUFFERSIZE = 8192;

        MessageDigest digest = java.security.MessageDigest.getInstance("MD5");
        InputStream is = new FileInputStream(file);
        byte[] buffer = new byte[BUFFERSIZE];
        int read = 0;
        while( (read = is.read(buffer)) > 0)
                digest.update(buffer, 0, read);
        
        return XnjsFileDB.md5Bytes2String(digest.digest());
	}
	
	static public String md5Bytes2String(byte[] md5) {
        BigInteger bi = new BigInteger(1, md5);
        return bi.toString(16);		
	}
	
}
