package de.pc2.unicore.edgi.xnjs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.event.ContinueProcessingEvent;
import de.fzj.unicore.xnjs.ems.event.EventHandler;
import de.fzj.unicore.xnjs.io.IFileTransfer;

class UtilSubactionManager {
	private final static Map<String, Runnable> map = new HashMap<String, Runnable>();
	private static Executor exec = null;
	private Object lock = new Object();
	
	public void add_and_execute(String uuid, Runnable r) {
		synchronized(lock) {		
			if (exec == null) {
				exec = Executors.newFixedThreadPool(2);
			}
			map.put(uuid, r);
			exec.execute(r);
		}
	}
	
	public String add_and_execute(Runnable r) {
		String uuid = UUID.randomUUID().toString();
		add_and_execute(uuid, r);
		return uuid;
	}
	
	public Runnable get(String uuid) {
		// -> every static to own class
		synchronized(lock) {
			Runnable r = map.get(uuid);
			return r;
		}
	}	
	
	public Runnable abort(String uuid) {
		synchronized(lock) {
			Runnable r = map.get(uuid);
			if (r != null) {
				map.remove(uuid);
			}
			return r;
		}		
	}
}

public class UtilSubaction {
	protected static final UtilSubactionManager manager = new UtilSubactionManager();
	
	public String groupid;
	public Action parent;
	public Configuration conf;
	
	public UtilSubaction(Configuration conf, Action parent, String groupid) {
		this.groupid = groupid;
		this.parent = parent;
		this.conf = conf;
	}
	
	public boolean hadSubactions() {
		return this.parent.getProcessingContext().get(this.groupid) != null;
	}
	
	@SuppressWarnings("unchecked")
	public ArrayList<String> getSubactionUUIDs() {
		ArrayList<String> ret = (ArrayList<String>)this.parent.getProcessingContext().get(groupid);
		if (ret == null) {
			// for the first time
			ret = new ArrayList<String>();
			this.parent.getProcessingContext().put(this.groupid, ret);
			this.parent.setDirty();
		}
		return ret;
	}
	
	public boolean pendingSubactions(){
		ArrayList<String> v = getSubactionUUIDs();
		assert v != null;
		return !v.isEmpty();
	}
	
	public void execSubaction(Runnable r) {
		String uuid = null;
		if (r instanceof IFileTransfer) {
			IFileTransfer ft = (IFileTransfer) r;
			uuid = ft.getUniqueId();
			manager.add_and_execute(uuid, r);
		} else {
			uuid = manager.add_and_execute(r);
		}
		getSubactionUUIDs().add(uuid);
		this.parent.addLogTrace("Subaction started: '"+uuid+"'.");
		this.parent.setDirty();
	}
	
	public ArrayList<Runnable> getSubactions() {
		ArrayList<String> uuids = getSubactionUUIDs();
		ArrayList<Runnable> ret = new ArrayList<Runnable>();
		for (String uuid: uuids) {
			ret.add(manager.get(uuid));
		}
		return ret;
	}
	
	public ArrayList<IFileTransfer> getSubactionsAsIFileTransfer() {
		ArrayList<String> uuids = getSubactionUUIDs();
		ArrayList<IFileTransfer> ret = new ArrayList<IFileTransfer>();
		for (String uuid: uuids) {
			Runnable r = manager.get(uuid);
			if (r instanceof IFileTransfer) {
				ret.add((IFileTransfer)r);				
			} else {
				this.parent.addLogTrace("data inconsistency, unexpected type not IFileTransfer of Subaction/Action: '"+uuid+"'/'"+this.parent.getUUID()+"'");
				this.parent.setDirty();
			}
		}
		return ret;		
	}
	
	public Runnable abort(String uuid) {
		Runnable ret = manager.abort(uuid);
		if (ret instanceof IFileTransfer) {
			((IFileTransfer)ret).abort();
		}
		this.getSubactionUUIDs().remove(uuid);
		this.parent.addLogTrace("Subaction abort: '"+uuid+"'.");
		this.parent.setDirty();
		return ret;
	}

	static class DelayedEvent implements Runnable {
		protected EventHandler handler;
		protected String actionid;
		public DelayedEvent(String actionid, EventHandler handler) {
			this.handler = handler;
			this.actionid = actionid;
		}
		@Override
		public void run() {
			try {
				handler.handleEvent(new ContinueProcessingEvent(actionid));
			} catch (Throwable e) {
	
			}
		}
		
	}
	
	public void wakeup(long delaysec) {
		Runnable r = new DelayedEvent(this.parent.getUUID(), conf.getInternalManager());
		if (delaysec == 0) {
			r.run();
		} else {
			conf.getScheduledExecutor().schedule(r, delaysec, TimeUnit.SECONDS);			
		}
	}
	
}
