package de.pc2.unicore.edgi.xnjs;

import java.net.MalformedURLException;
import java.net.URL;

import org.apache.log4j.Logger;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionException;

public class UtilConfigWrapper {
	Logger log;
	Configuration configuration;
	
	public UtilConfigWrapper(Configuration configuration, Logger log){
		assert log != null;
		assert configuration != null;
		this.configuration = configuration;
		this.log = log;
	}
	
	public String getProperty(String name, String default_value) throws ExecutionException {
		return getProperty(name, default_value, false);
	}
	
	public String getProperty(String name, String default_value, boolean optional) throws ExecutionException {
		String v_as_str = configuration.getProperty(name, null);
		
		if (v_as_str == null) {
			if (default_value == null) {
				if (!optional) {
					// well, a not given default imply that the value has to be configured.
					throw new ExecutionException("config file: required Variable '"+name+"' not specified (xnjs.xml)");
				}
			}
			log.warn("Variable '"+name+"' not configured => used default '"+default_value+"'");
			return default_value;
		}
		return v_as_str;
	}
	
	public URL getPropertyURL(String name, URL default_value) throws ExecutionException {
		return getPropertyURL(name, default_value, false);
	}
	
	public URL getPropertyURL(String name, URL default_value, boolean optional) throws ExecutionException {
		String v_as_str = configuration.getProperty(name, null);

		// convert
		URL v = null;
		if (v_as_str != null) {
			try {
				v = (URL) new URL(v_as_str);
			} catch (MalformedURLException e) {
				log.error("Variable '"+name+"' : '"+v_as_str+"' not parsable  => used default '"+default_value+"': " + e);
			}
		}
		
		if (v == null || v_as_str == null) {
			if (default_value == null) {
				if (!optional) {
					// well, a not given default imply that the value has to be configured.
					throw new ExecutionException("config file: required Variable '"+name+"' not specified (xnjs.xml)");
				}
			}
			log.warn("Variable '"+name+"' not configured => used default '"+default_value+"'");
			return default_value;
		}
		return v;
	}

	public int getPropertyInt(String name, int default_value) throws ExecutionException {
		String v_as_str = configuration.getProperty(name, null);

		// convert
		Integer v = null;
		if (v_as_str != null) {
			try {
				v = new Integer(v_as_str);
			} catch (NumberFormatException e) {
				log.error("Variable '"+name+"' : '"+v_as_str+"' not parsable  => used default '"+default_value+"': " + e);
			}
		}
		
		if (v == null || v_as_str == null) {
			log.warn("Variable '"+name+"' not configured => used default '"+default_value+"'");
			return default_value;
		}
		return v.intValue();
	}
	
	public boolean getPropertyBool(String name, boolean default_value) throws ExecutionException {
		String v_as_str = configuration.getProperty(name, null);

		// convert
		Boolean v = null;
		if (v_as_str != null) {
			try {
				v = new Boolean(v_as_str);
			} catch (NumberFormatException e) {
				log.error("Variable '"+name+"' : '"+v_as_str+"' not parsable  => used default '"+default_value+"': " + e);
			}
		}
		
		if (v == null || v_as_str == null) {
			log.warn("Variable '"+name+"' not configured => used default '"+default_value+"'");
			return default_value;
		}
		return v.booleanValue();
	}
}
