package de.pc2.unicore.edgi.xnjs;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map.Entry;

import org.apache.log4j.Logger;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.SourceTargetType;

import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.pc2.unicore.edgi.xnjs.io.passthrough.PassthroughCapabilities;
import de.pc2.unicore.edgi.xnjs.io.passthrough.URIComposed;

public class UtilAction {
	
	static protected final Logger log = LogUtil.getLogger(LogUtil.TSI, UtilAction.class);
	
	protected Action a = null;
	protected JobDefinitionType jsdl = null;
	protected DataStagingType[] staging = null;
	
	public UtilAction(Action a) {
		this.a = a;
	}
	
	JobDefinitionType getJSDL() {
		if (jsdl == null) {
			jsdl = ((JobDefinitionDocument)a.getAjd()).getJobDefinition();
		}
		return jsdl;
	}
	
	DataStagingType[] getStaging() {
		if (staging == null) {
			staging = getJSDL().getJobDescription().getDataStagingArray();
		}
		return staging;
	}
	
	// TODO: UPGRADE: Replace StagingEntry with DataStageInInfo
	public static class StagingEntry {
		public String uri;
		public URIComposed uric;
		public String uri_org;
		public String filename;
		public File file;
		public String name;
		public boolean stagein;
		
		public StagingEntry(String uri, String name, String filename, boolean stagein) {
			this.uri = this.uri_org = uri; 
			this.uric = null;
			this.name = name; 
			this.filename = filename;
			this.stagein = stagein;
		}
		
		public String toString() {
			return "URI_ORG="+this.uri_org+", URI="+this.uri+
			       ", URIC="+this.uric.toString()+
			       ", LN="+this.filename+
				   ", LFN="+this.name+", PATH="+this.file.toString()+", NAME="+this.name;
		}
		
		static public StagingEntry fromDS(DataStagingType stage){
			String name = stage.getName();
			SourceTargetType x = stage.getSource();
			boolean stagein = (x != null);
			if (x==null) {
				x = stage.getTarget();
			}
			assert x != null;
			String filename = stage.getFileName();
			String uri = x.getURI();

			return new UtilAction.StagingEntry(uri, name, filename, stagein);
		}
	}
	
	public ArrayList<StagingEntry> getStagingEntries(boolean forStagin) {
		getStaging();
		if (this.staging == null) {
			return null;
		}
		ArrayList<StagingEntry> ret = new ArrayList<StagingEntry>();
		String files = "";
		ExecutionContext ec = a.getExecutionContext();
		if (ec != null) {
			HashMap<String, String> env = ec.getEnvironment();
			// this is a workaround for rich client pre submitted files (generic widget)
			if (forStagin) {
				//files = env.get("INPUT"); "invisible client local file stagins" are now handled by looking into the job working directory
			} else {
				// workaround for "invisible client local file stagouts"; server know nothing about these; for now it has to be specified by hand
				files = env.get("OUTPUT");  
			}
			if (files == null){ 
				files = "";
			} 
		}
		for (DataStagingType s: getStaging()){
			StagingEntry x = UtilAction.StagingEntry.fromDS(s);
			if (x.stagein == forStagin) {
				ret.add(x);
				files = files.replaceFirst(x.filename, "").trim();
			}
		}
		if (files.length() > 0) {
			for (String i: files.split(" ")) {
				StagingEntry x = new StagingEntry(null, i, i, true);
				ret.add(x);
			}
		}
		return ret;
	}
	
	public ArrayList<StagingEntry> getStagingInEntries_dgconverted(String httpLocalPrefix, String httpRemotePrefix) throws ExecutionException {
		ArrayList<StagingEntry> ret = getStagingEntries(true);
		HashMap<StagingEntry, String> err = new HashMap<StagingEntry, String>();
		String ucjobwd = a.getExecutionContext().getWorkingDirectory();
		File ucjobwd_file = new File(ucjobwd);
		String dgjobwd = ucjobwd.replace(httpLocalPrefix, httpRemotePrefix);
		assert !ucjobwd.equals(dgjobwd): "data inconsistency, local and remote file path is equal but shouldn't.";
		
		List<String> already_stagedin_files = new ArrayList<String>(Arrays.asList(ucjobwd_file.list()));
		
		for (StagingEntry e: ret) {
			if (e.filename == null) {
				err.put(e, "internal error, no logical filename.");
				continue;
			}
			if (already_stagedin_files.contains(e.filename)) {
				already_stagedin_files.remove(e.filename);
			}
			
			e.file = new File(ucjobwd, e.filename);
			e.uri = dgjobwd + e.filename;
			if (e.uri_org != null && PassthroughCapabilities.isValidUri(e.uri_org)) {
				if (!e.file.exists()) {
					e.file = null; // no local file
					// ok, a bit tricky:
					// if the data file doesn't exists in working directory 
					//      => the uri_org has a correct format and passthrough is valid
					// if not (the data file exists)
					//      => so uri_org is not valid to passthrough format 
					URIComposed uric;
					try {
						uric = URIComposed.fromOuterURI(new URI(e.uri_org));
						e.uric = uric;
						e.uri = uric.toComposed();						
					} catch (NumberFormatException e1) {
						err.put(e, "internal error: "+e1.toString());
					} catch (URISyntaxException e1) {
						err.put(e, "internal error: "+e1.toString());
					} 					
				}
			}
		}
		
		// add unprocessed but locally present files for stagin
		// workaround for "invisible client local file stagins"  
		for (String fn: already_stagedin_files) {
			//String uri, String name, String filename, boolean stagein
			StagingEntry e = new StagingEntry(dgjobwd + fn, fn, fn, true);
			e.file = new File(ucjobwd, e.filename);
			ret.add(e);
		}
		
		if (err.size() > 0) {
			StringBuilder sb = new StringBuilder();
			for (Entry<StagingEntry, String> entry: err.entrySet()) {
				//ret.remove(entry.getKey());
				sb.append(entry.getValue() + "\n   ");
				sb.append(entry.getKey().toString());
			}
			throw new ExecutionException(sb.toString());
		}
		
		return ret;
	}
	
}
