package de.pc2.unicore.edgi.xnjs;

import java.net.URL;

import org.apache.log4j.Logger;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.pc2.unicore.edgi.monitoring.ReportException;
import de.pc2.unicore.edgi.monitoring.XMLLogReport;

public class MonitoringHelperThread implements Runnable {
	static protected final Logger log = LogUtil.getLogger(LogUtil.TSI, MonitoringHelperThread.class);
	private XMLLogReport report;
	private boolean isRunning;

	public MonitoringHelperThread(XMLLogReport report) {
		this.report = report;
		this.isRunning = true;
	}
	
	public void run() {
		if (this.isRunning) {
			try {
				Thread.sleep(report.getReportingInterval() * 1000);
			} catch (InterruptedException e) {
				LogUtil.logException("ignored exception ", e, log);
			}
			
			try {
				report.output();
			} catch (ReportException e) {
				LogUtil.logException("ignored exception while writing monitoring event", e, log);
			}
			
			try {
				report.cleanup();
			} catch (ReportException e) {
				LogUtil.logException("while cleaningup old files", e, log);
			}
			
		}
	}
	
    public void stopit() {
    	this.isRunning = false;
    }
    
    public XMLLogReport getReport(){
    	return report;
    }
    
	public static MonitoringHelperThread createFromConfiguration(Configuration conf, XMLLogReport lr) throws ExecutionException {
		if (lr.isdisabled()) {
			return null;
		}
		return new MonitoringHelperThread(lr);
	}
	
	public static XMLLogReport createLogReportFromConfiguration(Configuration conf) throws ExecutionException, ReportException {
		UtilConfigWrapper helper = new UtilConfigWrapper(conf, log);
		String reportsPath = helper.getProperty("MONITOR.directory", null);
		long reportingInterval = helper.getPropertyInt("MONITOR.interval_save", 600); 
		long cleanupAgeHour = helper.getPropertyInt("MONITOR.interval_cleanup", 168);
		URL test_remote = helper.getPropertyURL("MONITOR.test_remote", null, true);
		
		XMLLogReport lr = new XMLLogReport(reportingInterval, cleanupAgeHour, reportsPath);
		log.info(lr.statusMessage(test_remote==null ? null : test_remote.toString()));
		return lr;
	}
}
