package de.pc2.unicore.edgi.xnjs;

import java.io.InputStream;
import java.io.OutputStream;

import org.apache.log4j.Logger;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.io.ChangeACL;
import de.fzj.unicore.xnjs.io.ChangePermissions;
import de.fzj.unicore.xnjs.io.FileFilter;
import de.fzj.unicore.xnjs.io.Permissions;
import de.fzj.unicore.xnjs.io.XnjsFile;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.io.XnjsStorageInfo;
import de.fzj.unicore.xnjs.management.Lifecycle;
import de.fzj.unicore.xnjs.simple.LocalTS;
import de.fzj.unicore.xnjs.tsi.TSI;
import de.fzj.unicore.xnjs.tsi.TSIBusyException;
import de.fzj.unicore.xnjs.util.LogUtil;

/**
 * ...
 * 
 * additional method for receiving additional cached xnjsfile-info (e.g. md5)
 *  - as a separate method (and not via getProperties) because only in special situation we need md5 and 
 *    does not have to be computed for all files
 * 
 * in spirit of de.fzj.unicore.xnjs.simple.LocalTS
 * 
 * @author mkeller
 *
 */
@Lifecycle(isSingleton=false)
public class DesktopGridTSI implements TSI {
	
	protected static final Logger log = LogUtil.getLogger(LogUtil.TSI,DesktopGridTSI.class);
	
	protected final Configuration configuration;
	protected final LocalTS delegateTSI;
	protected final XnjsFileDB xnjsfileDB;
	
	
	public DesktopGridTSI(Configuration configuration) {
		this.configuration = configuration;
		delegateTSI = new LocalTS(configuration);
		xnjsfileDB = new XnjsFileDB();
	}
	
	@Override
	public void exec(String what, ExecutionContext ec) throws TSIBusyException, ExecutionException {
		throw new RuntimeException("not implemented, not needed");
	}

	@Override
	public void execAndWait(String what, ExecutionContext ec)
			throws TSIBusyException, ExecutionException 
	{
		throw new RuntimeException("not implemented, not needed");
	}

	@Override
	public String getEnvironment(String name) throws ExecutionException {
		//throw new RuntimeException("not implemented, not needed");
		return delegateTSI.getEnvironment(name);
	}

	@Override
	public String getHomePath() throws ExecutionException {
		return delegateTSI.getHomePath();
	}

	@Override
	public boolean isLocal() {
		return true; //delegateTSI.isLocal();
	}

	@Override
	public void mkfifo(String name) throws ExecutionException {
		delegateTSI.mkfifo(name);
	}

	@Override
	public String resolve(String name) throws ExecutionException {
		return delegateTSI.resolve(name);
	}

	@Override
	public void setClient(eu.unicore.security.Client client) {
		delegateTSI.setClient(client);
	}

	@Override
	public void chmod(String file, Permissions perm) throws ExecutionException {
		log.debug("chmod " + file + "<empty method>");
	}

	@Override
	public void cp(String source, String target) throws ExecutionException {
		log.debug("cp "+source+" -> " +target+ " ");
		delegateTSI.cp(source, target);
	}

	@Override
	public XnjsFile[] find(String base, FileFilter options, int offset,
			int limit) throws ExecutionException 
	{
		log.debug("find " + base);
		return this.delegateTSI.find(base, options, offset, limit);
	}

	@Override
	public XnjsStorageInfo getAvailableDiskSpace(String path) {
		log.debug("getAvailableDiskSpace " + path);
		return this.delegateTSI.getAvailableDiskSpace(path);
	}

	@Override
	public String getFileSeparator() throws ExecutionException {
		return delegateTSI.getFileSeparator();
	}

	@Override
	public String getFileSystemIdentifier() {
		log.debug("getFileSystemIdentifier");		
		return null;
	}

	@Override
	public InputStream getInputStream(String resource) throws ExecutionException {
		return this.delegateTSI.getInputStream(resource);
	}

	@Override
	public OutputStream getOutputStream(String resource) throws ExecutionException {
		return getOutputStream(resource, false);
	}

	@Override
	public OutputStream getOutputStream(String resource, boolean append)
			throws ExecutionException 		
	{
		log.debug("getOutputStream " + resource + ": append = " + append);
		return this.delegateTSI.getOutputStream(resource, append);
	}

	@Override
	public XnjsFileWithACL getProperties(String file) throws ExecutionException {
		log.debug("getProperties " + file);
		return this.delegateTSI.getProperties(file);
	}

	@Override
	public XnjsFile[] ls(String base) throws ExecutionException {
		log.debug("ls " + base);
		return this.delegateTSI.ls(base);
	}

	@Override
	public XnjsFile[] ls(String base, int offset, int limit, boolean filter)
			throws ExecutionException 
	{
		log.debug("ls " + base);
		return this.delegateTSI.ls(base, offset, limit, filter);
	}

	@Override
	public void mkdir(String dir) throws ExecutionException {
		delegateTSI.mkdir(dir);
	}

	@Override
	public void rename(String source, String target) throws ExecutionException {
		delegateTSI.rename(source, target);
	}
	
	@Override
	public void link(String source, String target) throws ExecutionException {
		delegateTSI.link(source, target);
	}

	@Override
	public void rm(String target) throws ExecutionException {
		log.debug("rm " + target);
		delegateTSI.rm(target);
	}

	@Override
	public void rmdir(String target) throws ExecutionException {
		log.debug("rmdir " + target);
		delegateTSI.rmdir(target);
	}

	@Override
	public String[] getGroups() throws TSIBusyException, ExecutionException {
		return this.delegateTSI.getGroups();
	}

	@Override
	public void chgrp(String file, String newGroup, boolean recursive)
			throws ExecutionException 
	{
		delegateTSI.chgrp(file, newGroup, recursive);
	}

	@Override
	public void chmod2(String file, ChangePermissions[] perm, boolean recursive)
			throws ExecutionException 
	{
		delegateTSI.chmod2(file, perm, recursive);
	}

	@Override
	public String getStorageRoot() {
		return delegateTSI.getStorageRoot();
	}

	@Override
	public boolean isACLSupported(String path) throws ExecutionException {
		return delegateTSI.isACLSupported(path);
	}

	@Override
	public void setStorageRoot(String root) {
		log.debug("setup new root: '"+root+"'.");
		delegateTSI.setStorageRoot(root);
	}

	@Override
	public void setUmask(String umask) {
		delegateTSI.setUmask(umask);		
	}

	@Override
	public String getUmask() {
		return delegateTSI.getUmask();		
	}
	
	@Override
	public void setfacl(String file, boolean clearAll, ChangeACL[] changeACL,
			boolean recursive) throws ExecutionException 
	{
		delegateTSI.setfacl(file, clearAll, changeACL, recursive);
	}
	

}
