package de.pc2.unicore.edgi.xnjs;

import java.util.Map;

import org.apache.log4j.Logger;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.management.Dependency;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.tsi.IExecution;
import de.fzj.unicore.xnjs.tsi.IExecutionSystemInformation;
import de.fzj.unicore.xnjs.tsi.TSIBusyException;
import de.fzj.unicore.xnjs.util.LogUtil;


/**
 * Desktop Grid execution system<br>
 * This implements job control, therefore bypass TSI related functionality (TSI provide interface for only one of the needed operation (exec))
 * 
 * @author mkeller
 */
@Dependency(classes={DesktopGridManager.class})
public class DesktopGridExecution implements IExecution, IExecutionSystemInformation {
	
	private static final Logger log=LogUtil.getLogger(LogUtil.JOBS, DesktopGridExecution.class);
	
	protected int update_interval = 3000;
	
	private final DesktopGridManager dgmanager;
	
	public DesktopGridExecution(Configuration config) throws ExecutionException{
		dgmanager = config.getComponentInstanceOfType(DesktopGridManager.class);
	}
	
	/**
	 * override basic doSubmit()
	 * @see de.fzj.unicore.xnjs.simple.BasicExecution#doSubmit(org.ggf.jsdl.posix.POSIXApplicationType, de.fzj.unicore.xnjs.ems.Action, de.fzj.unicore.xnjs.ems.ExecutionContext)
	 */
	@Override
	public void submit(Action job) throws TSIBusyException, ExecutionException {
		try {
			log.info("do Submit "+DesktopGridManager.logmsgprefix(job));
			ApplicationInfo appDescription=job.getApplicationInfo();
			dgmanager.submit(appDescription, job);
		} catch (Exception ex){ 
			throw new ExecutionException(ex);
		}
	}
	
	/* (non-Javadoc)
	 * @see de.fzj.unicore.xnjs.ems.IExecution#updateStatus(de.fzj.unicore.xnjs.ems.Action)
	 */
	public void updateStatus(Action job) throws ExecutionException {
		try {
			log.debug("updateStatus " + DesktopGridManager.logmsgprefix(job));
			dgmanager.updateStatus(job, null);
		} catch (Exception ex){ 
			throw new ExecutionException(ex);
		}
	}
	
	@Override
	public void abort(Action job) throws ExecutionException {
		try {
			log.info("abort " + DesktopGridManager.logmsgprefix(job));
			dgmanager.delete(job);
		} catch (Exception ex){ 
			throw new ExecutionException(ex);
		}
	}

	@Override
	public int getNumberOfQueuedJobs() {
		return 0;
	}

	@Override
	public int getNumberOfRunningJobs() {
		return 0;
	}

	@Override
	public int getTotalNumberOfJobs() {
		return 0;
	}

	@Override
	public void checkpoint(Action job) throws ExecutionException {
		throw new IllegalStateException("Operation is not supported.");
	}

	@Override
	public void pause(Action job) throws ExecutionException {
		throw new IllegalStateException("Operation is not supported.");
	}

	@Override
	public void restart(Action job) throws ExecutionException {
		throw new IllegalStateException("Operation is not supported.");
	}

	@Override
	public void resume(Action job) throws ExecutionException {
		throw new IllegalStateException("Operation is not supported.");
	}

	@Override
	public Map<String, Integer> getQueueFill() {
		return null;
	}
}