package de.fzj.unicore.uas.impl.dsms.operation.helper;

import java.util.concurrent.Callable;

import org.unigrids.services.atomic.types.GridFileType;

import pl.edu.icm.dsms.catalogue.model.Lda;
import de.fzj.unicore.uas.client.StorageClient;

public class ListDirectoryCallable implements Callable<GridFileType[]> {
	private final Lda lda;
	
	private final ClientHelper clientHelper;

	public ListDirectoryCallable(Lda lda, ClientHelper clientHelper) {
		this.lda = lda;
		this.clientHelper = clientHelper;
	}

	@Override
	public GridFileType[] call() throws Exception {
		StorageClient sms = clientHelper.getStorageClient(lda);
		return sms.listDirectory(lda.getPhysicalName());
	}

}
