package de.fzj.unicore.uas.impl.dsms.operation.helper;

import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import pl.edu.icm.dsms.catalogue.CatalogueClient;
import pl.edu.icm.dsms.catalogue.CatalogueUtils;
import pl.edu.icm.dsms.catalogue.model.Lda;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.impl.dsms.OperationContext;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;

public class ClientHelper {
	private static final Logger logger = Log.getLogger(LogUtil.SERVICES, ClientHelper.class);

	private IClientConfiguration commonTrustDelegation;
	
	private IClientConfiguration commonCatalogueTrustDelegation;
	
	private OperationContext c;
	
	private CatalogueClient cat;
	
	private EndpointReferenceType cachedCatalogueEpr;

	public ClientHelper(OperationContext context) {
		this.c = context;
		this.cachedCatalogueEpr = c.getCatalogueEpr();
		this.commonTrustDelegation = CatalogueUtils.getTrustDelegation(c.getKernel(), c.getClient());
		this.commonCatalogueTrustDelegation = CatalogueUtils.getTrustDelegation(c.getKernel(), c.getClient(),
				cachedCatalogueEpr, null);
	}

	/**
	 * Get storage client. If it's possible, connection will be made on behalf of user.
	 * 
	 * @param lda
	 * @param client
	 * @return
	 * @throws Exception
	 */
	public StorageClient getStorageClient(Lda lda) throws Exception {
		try {
			return new StorageClient(lda.getSms(), commonTrustDelegation);
		} catch (Exception e) {
			logger.error("Error in connecting to the Storage " + lda.getSmsAddress(), e);
			throw e;
		}
	}

	public CatalogueClient getCatalogueClient() throws BaseFault {
		if (cat != null) {
			return cat;
		}
		try {
			cat = CatalogueClientUtils.getCatalogueClient(commonCatalogueTrustDelegation, cachedCatalogueEpr);
		} catch (Exception e) {
			throw BaseFault.createFault("Can't get catalogue", e);
		}
		if (cat == null) {
			throw BaseFault.createFault("Catalogue EPR is empty");
		}
		return cat;
	}
}
