package de.fzj.unicore.uas.impl.dsms.operation.helper;

import java.io.FileNotFoundException;
import java.util.EmptyStackException;
import java.util.Stack;
import java.util.concurrent.Callable;

import org.apache.log4j.Logger;
import org.unigrids.services.atomic.types.GridFileType;

import pl.edu.icm.dsms.catalogue.CatalogueClient;
import pl.edu.icm.dsms.catalogue.CatalogueUtils;
import pl.edu.icm.dsms.catalogue.model.Lda;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.util.LogUtil;
import eu.unicore.util.Log;

class CheckFileOnSmsCallable implements Callable<StorageClientWithFile> {
	private static final Logger logger = Log.getLogger(LogUtil.SERVICES, CheckFileOnSmsCallable.class);

	private final Stack<Lda> ldas;

	private final String physical;

	private final ClientHelper clientHelper;

	public CheckFileOnSmsCallable(Stack<Lda> ldas, CatalogueClient cat, String path, String dSmsId,
			String dSmsRoot, ClientHelper clientHelper) {
		this.ldas = ldas;
		this.physical = CatalogueUtils.getPhysicalName(path, dSmsRoot);
		this.clientHelper = clientHelper;
	}

	@Override
	public StorageClientWithFile call() throws Exception {
		while (true) {
			Lda lda;
			try {
				lda = ldas.pop();
			} catch (EmptyStackException e) {
				return null;
			}
			logger.debug("Looking for " + physical + " on " + lda.getSmsAddress());
			StorageClient storage = clientHelper.getStorageClient(lda);

			GridFileType gridFileType = null;
			try {
				gridFileType = storage.listProperties(physical);
			} catch (FileNotFoundException e) {
				continue;
			}
			logger.debug("Found " + physical + " on " + lda.getSmsAddress());

			return new StorageClientWithFile(storage, gridFileType);
		}
	}
	
	
}
