package de.fzj.unicore.uas.impl.dsms.operation.helper;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.log4j.Logger;
import org.oasisOpen.docs.wsrf.sg2.EntryType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import pl.edu.icm.dsms.catalogue.Catalogue;
import pl.edu.icm.dsms.catalogue.CatalogueClient;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.ExternalRegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryHandler;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.IClientConfiguration;

public class CatalogueClientUtils {
	private static final Logger logger = Log.getLogger(LogUtil.SERVICES, CatalogueClientUtils.class);

	private CatalogueClientUtils() {

	}

	public static EndpointReferenceType createCatalogueEpr(Kernel kernel, String address) throws Exception {
		if (address != null) {
			EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
			epr.addNewAddress().setStringValue(address);
			CatalogueClient cat = new CatalogueClient(epr, kernel.getClientConfiguration());
			String catalogueDn = cat.getResourcePropertiesDocument().getCatalogueProperties()
					.getSharedStorageProperties().getCatalogueDn();
			WSUtilities.addServerIdentity(epr, catalogueDn);
			return epr;
		} else {
			return getCatalogueFromRegistry(kernel);
		}
	}

	private static EndpointReferenceType getCatalogueFromRegistry(Kernel kernel) throws Exception {
		CatalogueClient cat;
		IClientConfiguration secProp = kernel.getClientConfiguration();

		List<EndpointReferenceType> eprs = listServices(Catalogue.CATALOGUE_PORT, kernel);
		if (eprs.size() == 0) {
			throw new Exception("No dCatalogue in registry");
		}

		for (EndpointReferenceType epr : eprs) {
			try {
				cat = new CatalogueClient(epr, secProp);
				cat.getCurrentTime();
				return epr;
			} catch (Exception e) {
				logger.error("Can't connect to dCatalouge " + epr.getAddress().getStringValue(), e);
				continue;
			}
		}
		throw new Exception("Can't connect to any dCatalogue");
	}

	public static CatalogueClient getCatalogueClient(IClientConfiguration sec, EndpointReferenceType epr)
			throws Exception {
		try {
			CatalogueClient cat;
			cat = new CatalogueClient(epr, sec);
			cat.getCurrentTime();
			return cat;
		} catch (Exception e) {
			logger.error("Can't connect to the dCatalogue", e);
			return null;
		}
	}

	/**
	 * Get services with given port from the registry.
	 * 
	 * @param port
	 * @return
	 * @throws Exception
	 */
	private static List<EndpointReferenceType> listServices(QName port, Kernel kernel) throws Exception {
		List<EndpointReferenceType> eprs;
		RegistryHandler rh = kernel.getAttribute(RegistryHandler.class);
		ExternalRegistryClient reg = rh.getExternalRegistryClient();
		if (reg != null)
			eprs = reg.listServices(port);
		else {
			eprs = new ArrayList<EndpointReferenceType>();
			for (EntryType e : rh.getRegistryClient().listEntries()) {
				EndpointReferenceType epr = e.getMemberServiceEPR();
				if (WSServerUtilities.extractInterfaceName(epr).equals(port))
					eprs.add(epr);
			}
		}
		return eprs;
	}

}
