package de.fzj.unicore.uas.impl.dsms.operation;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.x2006.x04.services.sms.SendFileDocument;

import pl.edu.icm.dsms.catalogue.model.Lda;

import de.fzj.unicore.uas.impl.dsms.OperationContext;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class SendFile extends AbstractOperation {

	public SendFile(OperationContext context) throws BaseFault {
		super(context);
	}

	@Override
	protected XmlObject performOperation(XmlObject in) throws Exception {
		SendFileDocument castedIn = (SendFileDocument) in;
		String source = castedIn.getSendFile().getSource();
		String targetURI = castedIn.getSendFile().getDestination();

		Lda lda = lookup(source);

		logger.debug("Sending data to <" + targetURI + "> source is <" + source + ">");

		castedIn.getSendFile().setSource(lda.getPhysicalName());
		return clientHelper.getStorageClient(lda).SendFile(castedIn);
	}

}
