package de.fzj.unicore.uas.impl.dsms.operation;

import java.io.FileNotFoundException;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.x2006.x04.services.sms.RenameDocument;
import org.unigrids.x2006.x04.services.sms.RenameResponseDocument;

import pl.edu.icm.dsms.catalogue.CatalogueUtils;
import pl.edu.icm.dsms.catalogue.model.Lda;
import pl.edu.icm.x2010.x10.services.catalogue.LdaType;
import pl.edu.icm.x2010.x10.services.catalogue.RenameResponseDocument.RenameResponse;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.impl.dsms.OperationContext;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class Rename extends AbstractOperation {

	public Rename(OperationContext context) throws BaseFault {
		super(context);
	}

	@Override
	protected XmlObject performOperation(XmlObject in) throws Exception {
		RenameDocument castedIn = (RenameDocument) in;
		String source = "", target = "";

		source = CatalogueUtils.normalizePath(castedIn.getRename().getSource());
		target = CatalogueUtils.normalizePath(castedIn.getRename().getDestination());

		Lda ldaSrc = lookup(source);
		if (ldaSrc.isDirectory()) {
			renameDirectory(source, target, ldaSrc);
		} else {
			renameFile(source, target, ldaSrc);
		}

		logger.debug("Renamed '" + source + "' -> '" + target + "'");
		RenameResponseDocument res = RenameResponseDocument.Factory.newInstance();
		res.addNewRenameResponse();
		return res;

	}

	private void renameFile(String source, String target, Lda ldaSrc) throws Exception, BaseFault,
			FileNotFoundException {
		clientHelper.getCatalogueClient().remove(source, c.getdSmsId());
		c.getCache().remove(source, c.getdSmsId());
		Lda ldaDst = clientHelper.getCatalogueClient().add(target, c.getdSmsId(), ldaSrc.getSms());

		StorageClient client = clientHelper.getStorageClient(ldaSrc);
		addHelper.makeParentDirs(ldaDst.getPhysicalName(), client);
		client.rename(ldaSrc.getPhysicalName(), ldaDst.getPhysicalName());
	}

	private void renameDirectory(String source, String target, Lda ldaSrc) throws BaseFault, Exception {
		RenameResponse response = clientHelper.getCatalogueClient().renameDir(source, target, c.getdSmsId());
		LdaType[] ldas = response.getSourceLda().getLdaArray();
		for(LdaType lda : ldas) {
			StorageClient client = clientHelper.getStorageClient(ldaSrc);
			client.rename(lda.getPhysicalFileName(), response.getNewName());
		}
		c.getCache().removeDir(source, c.getdSmsId());
	}
}
