package de.fzj.unicore.uas.impl.dsms.operation;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.x2006.x04.services.sms.ReceiveFileDocument;

import de.fzj.unicore.uas.impl.dsms.OperationContext;
import de.fzj.unicore.uas.impl.dsms.operation.helper.AddHelper.FilenameAndClient;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class ReceiveFile extends AbstractOperation {

	public ReceiveFile(OperationContext context) throws BaseFault {
		super(context);
	}

	@Override
	protected XmlObject performOperation(XmlObject in) throws Exception {
		ReceiveFileDocument castedIn = (ReceiveFileDocument) in;
		String sourceURI = castedIn.getReceiveFile().getSource();
		String target = castedIn.getReceiveFile().getDestination();

		FilenameAndClient pfac = add(target);

		logger.debug("Receiving data from <" + sourceURI + "> target is <" + target + ">");
		castedIn.getReceiveFile().setDestination(pfac.getFilename());
		return pfac.getClient().ReceiveFile(castedIn);
	}

}
