package de.fzj.unicore.uas.impl.dsms.operation;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.x2006.x04.services.sms.ListPropertiesDocument;
import org.unigrids.x2006.x04.services.sms.ListPropertiesResponseDocument;

import pl.edu.icm.dsms.catalogue.CatalogueUtils;
import pl.edu.icm.dsms.catalogue.exception.FileNotExistsFault;
import pl.edu.icm.dsms.catalogue.model.Lda;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.impl.dsms.OperationContext;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class ListProperties extends AbstractOperation {

	public ListProperties(OperationContext context) throws BaseFault {
		super(context);
	}

	@Override
	protected XmlObject performOperation(XmlObject in) throws Exception {
		ListPropertiesDocument castedIn = (ListPropertiesDocument) in;
		ListPropertiesResponseDocument res = ListPropertiesResponseDocument.Factory.newInstance();
		res.addNewListPropertiesResponse();
		String request = null;
		try {
			request = castedIn.getListProperties().getPath();
			logger.debug("Listing properties of " + request);

			Lda lda;
			StorageClient storage;
			lda = lookup(request);
			storage = clientHelper.getStorageClient(lda);

			GridFileType file = storage.listProperties(lda.getPhysicalName());
			file.setPath(CatalogueUtils.getLogicalName(file.getPath(), c.getdSmsRoot()));
			res.getListPropertiesResponse().setGridFile(file);
			return res;
		} catch (FileNotExistsFault e) {
			logger.info("Can't find file " + request, e);
		}
		return res;

	}

}
