package de.fzj.unicore.uas.impl.dsms.operation;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.x2006.x04.services.sms.ListDirectoryDocument;
import org.unigrids.x2006.x04.services.sms.ListDirectoryResponseDocument;
import org.unigrids.x2006.x04.services.sms.ListDirectoryResponseDocument.ListDirectoryResponse;

import pl.edu.icm.dsms.catalogue.CatalogueUtils;
import pl.edu.icm.dsms.catalogue.model.Lda;

import de.fzj.unicore.uas.impl.dsms.OperationContext;
import de.fzj.unicore.uas.impl.dsms.operation.helper.ListDirectoryCallable;
import de.fzj.unicore.uas.impl.sms.SMSBaseImpl;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class ListDirectory extends AbstractOperation {

	public ListDirectory(OperationContext context) throws BaseFault {
		super(context);
	}

	@Override
	protected XmlObject performOperation(XmlObject in) throws Exception {
		ListDirectoryDocument castedIn = (ListDirectoryDocument) in;
		String p = "";

		ListDirectoryResponseDocument resd = ListDirectoryResponseDocument.Factory.newInstance();
		ListDirectoryResponse res = resd.addNewListDirectoryResponse();
		BigInteger offsetP = castedIn.getListDirectory().getOffset();
		int offset = (offsetP != null ? offsetP.intValue() : 0);
		BigInteger limitP = castedIn.getListDirectory().getLimit();
		int limit = limitP != null ? limitP.intValue() : SMSBaseImpl.MAX_LS_RESULTS;
		if (limit > SMSBaseImpl.MAX_LS_RESULTS) {
			String msg = "Could not list directory: the requested number of results "
					+ "exceeds the internal limit of <" + SMSBaseImpl.MAX_LS_RESULTS + ">. "
					+ "Please use the limit and offset parameters!";
			logger.warn(msg);
			throw new Exception(msg);
		}

		p = CatalogueUtils.normalizePath(castedIn.getListDirectory().getPath());
		logger.debug("Listing '" + p + "'");

		List<Lda> ldas = lookupDir(p);
		if (ldas == null || ldas.size() == 0)
			return resd;
		Collections.sort(ldas, new Comparator<Lda>() {
			public int compare(Lda o1, Lda o2) {
				int r = o1.getSmsAddress().compareTo(o2.getSmsAddress());
				if (r != 0)
					return r;
				r = o1.getPhysicalName().compareTo(o2.getPhysicalName());
				return r;
			}
		});

		ExecutorService executor = c.getKernel().getContainerProperties().getThreadingServices().
				getExecutorService();
		List<Future<GridFileType[]>> futures = new ArrayList<Future<GridFileType[]>>();
		List<GridFileType[]> fileLists = new ArrayList<GridFileType[]>();

		for (Lda lda : ldas)
			futures.add(executor.submit(new ListDirectoryCallable(lda, clientHelper)));

		for (Future<GridFileType[]> future : futures)
			try {
				if (future.get() != null)
					fileLists.add(future.get());
			} catch (Exception e) {
				logger.error("Can't get file list", e.getCause());
			}

		int i = 0, j = 0;
		Set<String> usedNames = new HashSet<String>();

		for (GridFileType[] files : fileLists) {
			for (GridFileType file : files) {
				if (j >= limit) {
					break;
				}
				if (usedNames.contains(file.getPath())) {
					continue;
				}
				usedNames.add(file.getPath());
				if (i++ >= offset) {
					file.setPath(CatalogueUtils.getLogicalName(file.getPath(), c.getdSmsRoot()));
					res.addNewGridFile();
					res.setGridFileArray(j++, file);
				}
			}
			if (j >= limit)
				break;
		}
		return resd;

	}

}
