package de.fzj.unicore.uas.impl.dsms.operation;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.x2006.x04.services.sms.ImportFileDocument;

import de.fzj.unicore.uas.impl.dsms.OperationContext;
import de.fzj.unicore.uas.impl.dsms.operation.helper.AddHelper.FilenameAndClient;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class ImportFile extends AbstractOperation {

	public ImportFile(OperationContext context) throws BaseFault {
		super(context);
	}

	@Override
	protected XmlObject performOperation(XmlObject in) throws Exception {
		ImportFileDocument castedIn = (ImportFileDocument) in;
		String dest = castedIn.getImportFile().getDestination();
		logger.debug("Importing '" + dest + "'");

		FilenameAndClient pfac = add(dest);

		castedIn.getImportFile().setDestination(pfac.getFilename());
		return pfac.getClient().ImportFile(castedIn);

	}
}
