package de.fzj.unicore.uas.impl.dsms.operation;

import java.util.Calendar;
import java.util.List;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.services.atomic.types.GridFileType;
import org.unigrids.x2006.x04.services.sms.FindDocument;
import org.unigrids.x2006.x04.services.sms.FindResponseDocument;
import org.unigrids.x2006.x04.services.sms.FindResponseDocument.FindResponse;

import pl.edu.icm.dsms.catalogue.CatalogueUtils;
import pl.edu.icm.dsms.catalogue.model.Lda;

import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.impl.dsms.OperationContext;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class Find extends AbstractOperation {

	public Find(OperationContext context) throws BaseFault {
		super(context);
	}

	@Override
	protected XmlObject performOperation(XmlObject in) throws Exception {
		FindDocument castedIn = (FindDocument) in;

		FindResponseDocument resd = FindResponseDocument.Factory.newInstance();
		FindResponse res = resd.addNewFindResponse();
		String base = "";

		org.unigrids.x2006.x04.services.sms.FindDocument.Find find = castedIn.getFind();
		base = find.getBase();
		logger.debug("Finding in '" + base + "'");

		Boolean recurse = find.getRecurse();
		Boolean regexp = false;
		String name = null;
		if (find.getFilter().isSetNameMatchRegExp()) {
			regexp = true;
			name = find.getFilter().getNameMatchRegExp();
		} else
			name = find.getFilter().getNameMatch();
		Calendar before = find.getFilter().getBefore();
		Calendar after = find.getFilter().getAfter();

		int i = 0;
		List<Lda> ldas = lookupDir(base);
		if (ldas == null || ldas.size() == 0)
			return resd;
		for (Lda lda : ldas) {
			StorageClient client;
			GridFileType files[];
			try {
				client = clientHelper.getStorageClient(lda);
				files = client.find(lda.getPhysicalName(), recurse, name, regexp, before, after);
			} catch (Exception e) {
				if (lda != null) {
					logger.error("Can't connect to SMS " + lda.getSmsAddress(), e);
				} else {
					logger.error("Can't connect to SMS", e);
				}
				continue;
			}

			for (GridFileType g : files) {
				g.setPath(CatalogueUtils.getLogicalName(g.getPath(), c.getdSmsRoot()));
				res.addNewGridFile();
				res.setGridFileArray(i++, g);
			}
		}
		return resd;

	}

}
