package de.fzj.unicore.uas.impl.dsms.operation;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.services.atomic.types.ProtocolType;
import org.unigrids.x2006.x04.services.sms.ExportFileDocument;

import pl.edu.icm.dsms.catalogue.model.Lda;

import de.fzj.unicore.uas.impl.dsms.OperationContext;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class ExportFile extends AbstractOperation {

	public ExportFile(OperationContext context) throws BaseFault {
		super(context);
	}

	@Override
	protected XmlObject performOperation(XmlObject in) throws Exception {
		ExportFileDocument castedIn = (ExportFileDocument) in;
		String source = castedIn.getExportFile().getSource();
		ProtocolType.Enum protocol = castedIn.getExportFile().getProtocol();
		Lda lda = lookup(source);

		logger.debug("Export: '" + source + "' " + protocol);
		castedIn.getExportFile().setSource(lda.getPhysicalName());
		return clientHelper.getStorageClient(lda).ExportFile(castedIn);

	}

}
