package de.fzj.unicore.uas.impl.dsms.operation;

import java.util.List;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.x2006.x04.services.sms.DeleteDocument;
import org.unigrids.x2006.x04.services.sms.DeleteResponseDocument;

import pl.edu.icm.dsms.catalogue.CatalogueUtils;
import pl.edu.icm.dsms.catalogue.model.Lda;

import de.fzj.unicore.uas.impl.dsms.OperationContext;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class Delete extends AbstractOperation {

	public Delete(OperationContext context) throws BaseFault {
		super(context);
	}

	@Override
	protected XmlObject performOperation(XmlObject in) throws Exception {
		DeleteDocument castedIn = (DeleteDocument) in;
		String path = CatalogueUtils.normalizePath(castedIn.getDelete().getPath());
		if (clientHelper.getCatalogueClient().isDir(path, c.getdSmsId())) {
			List<Lda> ldaList = clientHelper.getCatalogueClient().removeDir(path, c.getdSmsId());
			for (Lda lda : ldaList) {
				clientHelper.getStorageClient(lda).delete(lda.getPhysicalName());
			}
			c.getCache().removeDir(path, c.getdSmsId());
		} else {
			Lda lda = clientHelper.getCatalogueClient().remove(path, c.getdSmsId());
			clientHelper.getStorageClient(lda).delete(lda.getPhysicalName());
			c.getCache().remove(path, c.getdSmsId());
		}

		logger.debug("Deleted '" + path + "'");
		DeleteResponseDocument res = DeleteResponseDocument.Factory.newInstance();
		res.addNewDeleteResponse();
		return res;

	}

}
