package de.fzj.unicore.uas.impl.dsms.operation;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.x2006.x04.services.sms.CreateDirectoryDocument;
import org.unigrids.x2006.x04.services.sms.CreateDirectoryResponseDocument;

import pl.edu.icm.dsms.catalogue.CatalogueUtils;

import de.fzj.unicore.uas.impl.dsms.OperationContext;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class CreateDirectory extends AbstractOperation {

	public CreateDirectory(OperationContext context) throws BaseFault {
		super(context);
	}

	@Override
	protected XmlObject performOperation(XmlObject in) throws Exception {
		CreateDirectoryDocument castedIn = (CreateDirectoryDocument) in;
		String path = CatalogueUtils.normalizePath(castedIn.getCreateDirectory().getPath());
		clientHelper.getCatalogueClient().addDir(path, c.getdSmsId());

		// in order to create dir on physical sms
		String tempFile = path + "/tempFile";
		add(tempFile);
		clientHelper.getCatalogueClient().remove(tempFile, c.getdSmsId());
		c.getCache().remove(path, c.getdSmsId());

		logger.debug("Created directory " + path);

		CreateDirectoryResponseDocument res = CreateDirectoryResponseDocument.Factory.newInstance();
		res.addNewCreateDirectoryResponse();
		return res;
	}
}
