package de.fzj.unicore.uas.impl.dsms.operation;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.x2006.x04.services.sms.CopyDocument;
import org.unigrids.x2006.x04.services.sms.CopyResponseDocument;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

import pl.edu.icm.dsms.catalogue.model.Lda;

import de.fzj.unicore.uas.client.TransferControllerClient;
import de.fzj.unicore.uas.impl.dsms.OperationContext;
import de.fzj.unicore.uas.impl.dsms.operation.helper.AddHelper.FilenameAndClient;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class Copy extends AbstractOperation {

	private final String protocol;

	public Copy(OperationContext context, String protocol) throws BaseFault {
		super(context);
		this.protocol = protocol;
	}

	@Override
	protected XmlObject performOperation(XmlObject in) throws Exception {
		CopyDocument castedIn = (CopyDocument) in;
		String source = "", target = "";

		source = castedIn.getCopy().getSource();
		target = castedIn.getCopy().getDestination();

		Lda lSource = lookup(source);
		FilenameAndClient lTarget = add(target);

		TransferControllerClient tcc = clientHelper.getStorageClient(lSource).sendFile(
				lSource.getPhysicalName(), getUrl(lTarget.getClient().getEPR(), lTarget.getFilename()));

		// wait just long enough to make sure the transfer was kicked off...
		int time = 0;
		while (!tcc.isComplete() && !tcc.hasFailed() && time < 5) {
			Thread.sleep(1000);
			time++;
		}
		if (tcc.hasFailed()) {
			String err = tcc.getStatus();
			throw new Exception("Send file failed: " + err);
		}

		logger.debug("Copied '" + source + "' -> '" + target + "'");

		CopyResponseDocument res = CopyResponseDocument.Factory.newInstance();
		res.addNewCopyResponse();
		return res;

	}

	/**
	 * Get file URL from SMS EPR, filename and given protocol.
	 * 
	 * @param lda
	 * @param protocol
	 * @return
	 */
	private String getUrl(EndpointReferenceType smsEpr, String filename) {
		StringBuilder builder = new StringBuilder();
		builder.append(protocol);
		builder.append(':');
		builder.append(smsEpr.getAddress().getStringValue());
		builder.append("#/");
		builder.append(filename);
		return builder.toString();
	}
}
