package de.fzj.unicore.uas.impl.dsms.operation;

import org.apache.xmlbeans.XmlObject;
import org.unigrids.x2006.x04.services.sms.ChangePermissionsDocument;
import org.unigrids.x2006.x04.services.sms.ChangePermissionsResponseDocument;

import pl.edu.icm.dsms.catalogue.model.Lda;

import de.fzj.unicore.uas.impl.dsms.OperationContext;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public class ChangePermissions extends AbstractOperation {

	public ChangePermissions(OperationContext context) throws BaseFault {
		super(context);
	}

	@Override
	protected XmlObject performOperation(XmlObject in) throws Exception {
		ChangePermissionsDocument castedIn = (ChangePermissionsDocument) in;

		String filename = castedIn.getChangePermissions().getPath();
		Lda lda = lookup(castedIn.getChangePermissions().getPath());
		clientHelper.getStorageClient(lda).ChangePermissions(lda.getPhysicalName(), castedIn);
		logger.debug("Changed user permissions for " + filename);

		ChangePermissionsResponseDocument res = ChangePermissionsResponseDocument.Factory.newInstance();
		res.addNewChangePermissionsResponse();
		return res;
	}

}
