package de.fzj.unicore.uas.impl.dsms.operation;

import java.util.List;

import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;

import pl.edu.icm.dsms.catalogue.CatalogueUtils;
import pl.edu.icm.dsms.catalogue.model.Lda;

import de.fzj.unicore.uas.impl.dsms.OperationContext;
import de.fzj.unicore.uas.impl.dsms.operation.helper.AddHelper;
import de.fzj.unicore.uas.impl.dsms.operation.helper.AddHelper.FilenameAndClient;
import de.fzj.unicore.uas.impl.dsms.operation.helper.ClientHelper;
import de.fzj.unicore.uas.impl.dsms.operation.helper.LookupHelper;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;

public abstract class AbstractOperation {

	protected final Logger logger;

	protected OperationContext c;
	
	protected AddHelper addHelper;
	
	protected ClientHelper clientHelper;
	
	protected LookupHelper lookupHelper;

	public AbstractOperation(OperationContext context) throws BaseFault {
		this.c = context;
		logger = LogUtil.getLogger(LogUtil.SERVICES, getClass());
		clientHelper = new ClientHelper(c);
		lookupHelper = new LookupHelper(clientHelper, c);
		addHelper = new AddHelper(clientHelper, lookupHelper, c);
	}

	public XmlObject perform(XmlObject in) throws BaseFault {
		try {
			return performOperation(in);
		} catch (Exception e) {
			logger.error("Can't perform dSMS operation. Exception occurred.", e);
			throw BaseFault.createFault("Can't perform " + getClass().getSimpleName(), e);
		}
	}

	protected abstract XmlObject performOperation(XmlObject in) throws Exception;

	protected Lda lookup(String filename) throws Exception {
		String normalizedFilename = CatalogueUtils.normalizePath(filename);
		Lda lda = lookupHelper.lookup(normalizedFilename).get(0);
		return lda;
	}
	
	protected List<Lda> lookupDir(String filename) throws Exception {
		String normalizedFilename = CatalogueUtils.normalizePath(filename);
		return lookupHelper.lookup(normalizedFilename);
	}
	
	protected FilenameAndClient add(String filename) throws Exception {
		String normalizedFilename = CatalogueUtils.normalizePath(filename);
		return addHelper.addFile(normalizedFilename);

	}
}
