package de.fzj.unicore.uas.impl.dsms.meta;

import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.Callable;

import org.unigrids.services.atomic.types.StatusType;
import org.unigrids.x2006.x04.services.metadata.ExtractionStatisticsDocument;

import de.fzj.unicore.uas.client.TaskClient;
import de.fzj.unicore.uas.metadata.ExtractionStatistics;

public class CombinedTaskClient implements Callable<ExtractionStatistics> {

	private final List<TaskClient> clients;

	public CombinedTaskClient(List<TaskClient> clients) {
		this.clients = clients;
	}

	@Override
	public ExtractionStatistics call() throws Exception {
		BigInteger documentsProcessed = BigInteger.ZERO;
		BigInteger durationMillis = BigInteger.ZERO;

		for (TaskClient tc : clients) {
			while (StatusType.SUCCESSFUL != tc.getStatus() && StatusType.FAILED != tc.getStatus()) {
				Thread.sleep(2000);
			}
			ExtractionStatisticsDocument es = ExtractionStatisticsDocument.Factory.parse(
					tc.getResult().newInputStream());
			BigInteger tcDocuments = es.getExtractionStatistics().getDocumentsProcessed();
			BigInteger tcDuration = es.getExtractionStatistics().getDurationMillis();
			if (tcDocuments != null) {
				documentsProcessed.add(tcDocuments);
			}
			if (tcDuration != null && durationMillis.compareTo(tcDuration) < 0) {
				durationMillis = tcDuration;
			}
		}
		ExtractionStatistics stats = new ExtractionStatistics();
		stats.setDocumentsProcessed(documentsProcessed.intValue());
		stats.setDurationMillis(durationMillis.longValue());
		return stats;
	}

}
