/*
 * Copyright (c) 2012 ICM Uniwersytet Warszawski All rights reserved. See LICENCE.txt file for licensing
 * information.
 */
package de.fzj.unicore.uas.impl.dsms;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import org.apache.log4j.Logger;

import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;

/**
 * This class is used to handle configuration of a particular DSMS instance, defined globally for the site.
 * 
 * @author K. Benedyczak
 */
public class DSMSProperties extends PropertiesHelper {

	private static final Logger log = Log.getLogger(Log.SERVICES, DSMSProperties.class);

	public static final String PROTOCOLS = "protocols";

	public static final String NAME = "name";

	public static final String DESCRIPTION = "description";

	public static final String DSMS_ENABLE_SYNC_1 = "sync1";

	public static final String DSMS_ENABLE_SYNC_2 = "sync2";

	public static final String DSMS_CATALOGUE = "catalogue";

	@DocumentationReferenceMeta
	public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();
	static {
		META.put(NAME, new PropertyMD().setDescription("Storage name."));
		META.put(
				PROTOCOLS,
				new PropertyMD().setUpdateable().setDescription(
						"Which protocols to enable, default is defined by the global container setting."));
		META.put(
				DESCRIPTION,
				new PropertyMD("Filesystem").setUpdateable().setDescription(
						"Description of the storage. It will be presented to the users."));
		META.put(
				DSMS_ENABLE_SYNC_1,
				new PropertyMD("false")
						.setUpdateable()
						.setDescription(
								"Unexpected file synchronization - whether to synchronize file which exists in SMS but not in the dCatalogue."));
		META.put(
				DSMS_ENABLE_SYNC_2,
				new PropertyMD("false")
						.setUpdateable()
						.setDescription(
								"Missing file synchronization - whether to synchronize file existing in dCatalogue but deleted from sms"));
		META.put(DSMS_CATALOGUE, new PropertyMD().setUpdateable().setDescription(""));
	}

	public DSMSProperties(String prefix, Properties properties) throws ConfigurationException {
		super(prefix, properties, META, log);
	}
}
