/*
 * Copyright (c) 2010 ICM Uniwersytet Warszawski All rights reserved. See LICENCE file for licensing
 * information.
 * 
 * Author: T. Rękawek <newton@mat.uni.torun.pl>
 */

package de.fzj.unicore.uas.impl.dsms;

import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.FileSystemType;

import de.fzj.unicore.uas.impl.sms.StorageDescription;
import de.fzj.unicore.uas.impl.sms.StorageInfoProvider;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import eu.unicore.security.Client;

/**
 * DSMS factory info provider
 * 
 * @author newton
 * 
 */
public class DSMSInfoProvider implements StorageInfoProvider, KernelInjectable {
	public void setKernel(Kernel k) {
	}

	@Override
	public FileSystemDocument getInformation(StorageDescription storage, Client client, String xnjsReference) {
		FileSystemDocument fs = FileSystemDocument.Factory.newInstance();
		FileSystemType fsType = fs.addNewFileSystem();
		fsType.setDescription("DSMS");
		return fs;
	}
}
